package com.icetech.user.service.impl;

import com.icetech.user.dao.TollBoxUserMapper;
import com.icetech.user.domain.entity.user.TollBoxUser;
import com.icetech.user.service.TollBoxUserService;
import com.icetech.db.mybatis.base.service.impl.BaseServiceImpl;
import org.springframework.stereotype.Service;

/**
 * 岗亭和收费员关联表 服务实现类
 *
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author fangct
 * @version 1.0 @date 2024-11-15
 */
@Service
public class TollBoxUserServiceImpl extends BaseServiceImpl<TollBoxUserMapper, TollBoxUser> implements TollBoxUserService {

    /**
     * Description: 根据ID查询 岗亭和收费员关联表对象信息 <br>
     * Version1.0 2024-11-15 by fangct创建
     *
     * @param id 对象id
     * @return TollBoxUser
     */
    @Override
    public TollBoxUser getTollBoxUserById (Long id) {
        return getById(id);
    }

    /**
     * Description: 新增  岗亭和收费员关联表对象信息 <br>
     * Version1.0 2024-11-15 by fangct创建
     *
     * @param entity 对象信息
     * @return Boolean 返回新增后主键
     */
    @Override
    public Boolean addTollBoxUser (TollBoxUser entity) {
        return save(entity);
    }

    /**
     * Description: 修改 岗亭和收费员关联表对象信息 <br>
     * Version1.0 2024-11-15 by fangct创建
     *
     * @param entity 对象信息
     * @return Boolean 返回更新后的结果
     */
    @Override
    public Boolean modifyTollBoxUser (TollBoxUser entity) {
        return updateById(entity);
    }

    /**
     * Description: 删除  岗亭和收费员关联表对象信息 <br>
     * Version1.0 2024-11-15 by fangct创建
     *
     * @param id 对象id
     * @return Boolean 返回更新后的结果
     */
    @Override
    public Boolean removeTollBoxUserById (Long id) {
        return removeById(id);
    }

}
