package com.icetech.user.service.impl;

import com.icetech.db.mybatis.base.service.impl.BaseServiceImpl;
import com.icetech.user.dao.TollBoxMapper;
import com.icetech.user.domain.entity.user.TollBox;
import com.icetech.user.service.TollBoxService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 岗亭设置表 服务实现类
 *
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author fangct
 * @version 1.0 @date 2024-11-15
 */
@Service
public class TollBoxServiceImpl extends BaseServiceImpl<TollBoxMapper, TollBox> implements TollBoxService {

    @Autowired
    private TollBoxMapper tollBoxMapper;

    @Override
    public List<TollBox> findChannelIdsByUserId(Integer userId) {
        return tollBoxMapper.getChannelIdsByUserId(userId);
    }

    /**
     * Description: 根据ID查询 岗亭设置表对象信息 <br>
     * Version1.0 2024-11-15 by fangct创建
     *
     * @param id 对象id
     * @return TollBox
     */
    @Override
    public TollBox getTollBoxById (Long id) {
        return getById(id);
    }

    /**
     * Description: 新增  岗亭设置表对象信息 <br>
     * Version1.0 2024-11-15 by fangct创建
     *
     * @param entity 对象信息
     * @return Boolean 返回新增后主键
     */
    @Override
    public Boolean addTollBox (TollBox entity) {
        return save(entity);
    }

    /**
     * Description: 修改 岗亭设置表对象信息 <br>
     * Version1.0 2024-11-15 by fangct创建
     *
     * @param entity 对象信息
     * @return Boolean 返回更新后的结果
     */
    @Override
    public Boolean modifyTollBox (TollBox entity) {
        return updateById(entity);
    }

    /**
     * Description: 删除  岗亭设置表对象信息 <br>
     * Version1.0 2024-11-15 by fangct创建
     *
     * @param id 对象id
     * @return Boolean 返回更新后的结果
     */
    @Override
    public Boolean removeTollBoxById (Long id) {
        return removeById(id);
    }

}
