package com.icetech.user.service.impl;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.icetech.cloudcenter.api.park.SaasUserParkService;
import com.icetech.user.dao.SaasUserParkMapper;
import com.icetech.user.domain.entity.user.SaasUserPark;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.db.mybatis.base.service.impl.BaseServiceImpl;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 用户与车场关联表 服务实现类
 * <p>
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wanggang
 * @version 1.0 @date 2021-08-26
 */
@Service("saasUserParkService")
public class SaasUserParkServiceImpl extends BaseServiceImpl<SaasUserParkMapper, SaasUserPark> implements SaasUserParkService {

    @Override
    public ObjectResponse<Void> deleteByParkIds(List<Integer> ids) {
        return removeByIds(ids) ? ObjectResponse.success() : ObjectResponse.failed();
    }

    @Override
    public List<SaasUserPark> listByParkId(Long parkId) {
        return list(Wrappers
                .lambdaQuery(SaasUserPark.class)
                .eq(SaasUserPark::getParkId, parkId));
    }

    @Override
    public List<SaasUserPark> getSaasUserParkByInstitutionIds(List<Integer> institutionIds) {
        return list(Wrappers
                .lambdaQuery(SaasUserPark.class)
                .in(SaasUserPark::getInstitutionId, institutionIds));
    }
}
