package com.icetech.user.service;

import com.icetech.db.mybatis.base.service.IBaseService;
import com.icetech.user.domain.entity.user.TollBoxUser;

/**
 * 岗亭和收费员关联表 服务类
 *
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author fangct
 * @version 1.0 @date 2024-11-15
 */
public interface TollBoxUserService extends IBaseService<TollBoxUser> {

    /**
     * Description: 根据ID查询 岗亭和收费员关联表对象信息 <br>
     * Version1.0 2024-11-15 by fangct创建
     *
     * @param id 对象id
     * @return TollBoxUser
     */
    TollBoxUser getTollBoxUserById (Long id);

    /**
     * Description: 新增  岗亭和收费员关联表对象信息 <br>
     * Version1.0 2024-11-15 by fangct创建
     *
     * @param entity 对象信息
     * @return Boolean 返回新增后主键
     */
    Boolean addTollBoxUser (TollBoxUser entity);

    /**
     * Description: 修改 岗亭和收费员关联表对象信息 <br>
     * Version1.0 2024-11-15 by fangct创建
     *
     * @param entity 对象信息
     * @return Boolean 返回更新后的结果
     */
    Boolean modifyTollBoxUser (TollBoxUser entity);

    /**
     * Description: 删除  岗亭和收费员关联表对象信息 <br>
     * Version1.0 2024-11-15 by fangct创建
     *
     * @param id 对象id
     * @return Boolean 返回更新后的结果
     */
    Boolean removeTollBoxUserById (Long id);
}
