package com.icetech.user.service;

import com.icetech.db.mybatis.base.service.IBaseService;
import com.icetech.user.domain.entity.user.TollBox;

import java.util.List;

/**
 * 岗亭设置表 服务类
 *
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author fangct
 * @version 1.0 @date 2024-11-15
 */
public interface TollBoxService extends IBaseService<TollBox> {

    /**
     * 根据用户ID查询权限下的通道ID
     * @param userId
     * @return
     */
    List<TollBox> findChannelIdsByUserId(Integer userId);
    /**
     * Description: 根据ID查询 岗亭设置表对象信息 <br>
     * Version1.0 2024-11-15 by fangct创建
     *
     * @param id 对象id
     * @return TollBox
     */
    TollBox getTollBoxById (Long id);

    /**
     * Description: 新增  岗亭设置表对象信息 <br>
     * Version1.0 2024-11-15 by fangct创建
     *
     * @param entity 对象信息
     * @return Boolean 返回新增后主键
     */
    Boolean addTollBox (TollBox entity);

    /**
     * Description: 修改 岗亭设置表对象信息 <br>
     * Version1.0 2024-11-15 by fangct创建
     *
     * @param entity 对象信息
     * @return Boolean 返回更新后的结果
     */
    Boolean modifyTollBox (TollBox entity);

    /**
     * Description: 删除  岗亭设置表对象信息 <br>
     * Version1.0 2024-11-15 by fangct创建
     *
     * @param id 对象id
     * @return Boolean 返回更新后的结果
     */
    Boolean removeTollBoxById (Long id);
}
