package com.icetech.user.service;

import com.icetech.db.mybatis.base.service.IBaseService;
import com.icetech.user.domain.entity.user.SaasNode;

import java.util.List;

/**
 * 菜单表 服务类
 *
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author fangct
 * @version 1.0 @date 2025-01-08
 */
public interface SaasNodeService extends IBaseService<SaasNode> {

    List<String> getActionListByToken(String token);
    /**
     * Description: 根据ID查询 菜单表对象信息 <br>
     * Version1.0 2025-01-08 by fangct创建
     *
     * @param id 对象id
     * @return SaasNode
     */
    SaasNode getSaasNodeById (Long id);

    /**
     * Description: 新增  菜单表对象信息 <br>
     * Version1.0 2025-01-08 by fangct创建
     *
     * @param entity 对象信息
     * @return Boolean 返回新增后主键
     */
    Boolean addSaasNode (SaasNode entity);

    /**
     * Description: 修改 菜单表对象信息 <br>
     * Version1.0 2025-01-08 by fangct创建
     *
     * @param entity 对象信息
     * @return Boolean 返回更新后的结果
     */
    Boolean modifySaasNode (SaasNode entity);

    /**
     * Description: 删除  菜单表对象信息 <br>
     * Version1.0 2025-01-08 by fangct创建
     *
     * @param id 对象id
     * @return Boolean 返回更新后的结果
     */
    Boolean removeSaasNodeById (Long id);
}
