package com.icetech.user.dao;

import com.icetech.user.domain.entity.user.WorkReport;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * WorkReportDAO继承基类
 */
@Repository
public interface WorkReportDao {
    int deleteByPrimaryKey(Integer id);

    int insert(WorkReport record);

    /**
     * 批量插入
     * @param records
     * @return
     */
    int batchInsert(@Param("records") List<WorkReport> records);

    int insertSelective(WorkReport record);

    WorkReport selectByPrimaryKey(WorkReport id);

    int updateByPrimaryKeySelective(WorkReport record);

    int updateByPrimaryKey(WorkReport record);

    /**
     * 校验当前车场 用户是否已经结账
     * @param userId
     * @param parkId
     * @return
     */
    WorkReport checkIsRecord(@Param("userId") Integer userId, @Param("parkId") Integer parkId);

    /**
     * 查询所有未结账的车场id
     * @param parkIds
     * @return
     */
    List<Long> selectUnReport(@Param("parkIds") List<Long> parkIds,@Param("userId") Integer userId);

    /**
     * 获取当次的上班时间
     * @param userId
     * @param parkId
     * @return
     */
    WorkReport selectByWorkOn(@Param("userId") Integer userId, @Param("parkId") Integer parkId);
}
