package com.icetech.user.dao;

import com.icetech.user.domain.entity.user.MpUser;
import com.icetech.user.domain.entity.user.MpUserPlate;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * 公众号用户登录
 *
 * Created by xuxueli on '2019-06-27 11:18:04'.
 */
@Component
public interface MpUserDao {

    /**
     * 新增
     */
    int insert(MpUser mpUser);
    int insertBind(MpUserPlate mpUserPlate);

    /**
     * 删除绑定关系
     * @param mpUserId
     * @param plateNum
     * @return
     */
    int deleteBind(@Param("mpUserId") Integer mpUserId,@Param("plateNum") String plateNum);
    /**
     * 删除
     */
    int delete(@Param("id") int id);

    /**
     * 更新
     */
    int update(@Param("mpUser") MpUser mpUser);

    /**
     * Load查询
     */
    MpUser load(@Param("id") int id);

    /**
     * 根据手机号查询
     * @param mobile
     * @return
     */
    MpUser selectByMobile(@Param("mobile") String mobile,@Param("openId") String openId,@Param("miniOpenId") String miniOpenId);

    List<String> selectPlateNumByUserId(@Param("mpUserId") Integer mpUserId);

    /**
     * 验证车牌是否被绑定
     * @param plateNum
     * @return
     */
    Integer verifyPlateNum(@Param("plateNum") String plateNum);

    /**
     * 根据车牌号获取用户信息
     * @param plateNum
     * @return
     */
    MpUser selectOpenIdByPlateNum(@Param("plateNum") String plateNum);
}
