/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.user.service.impl;

import cn.hutool.core.util.StrUtil;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.icetech.cloudcenter.api.park.ParkService;
import com.icetech.cloudcenter.api.park.SaasUserParkService;
import com.icetech.cloudcenter.api.user.UserService;
import com.icetech.cloudcenter.domain.response.SaasUserDto;
import com.icetech.common.constants.CodeConstantsEnum;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.park.domain.entity.park.Park;
import com.icetech.user.dao.MpUserDao;
import com.icetech.user.dao.SaasUserDao;
import com.icetech.user.dao.UserDefultAisleDao;
import com.icetech.user.domain.entity.user.MpUser;
import com.icetech.user.domain.entity.user.MpUserPlate;
import com.icetech.user.domain.entity.user.SaasInstitution;
import com.icetech.user.domain.entity.user.SaasUser;
import com.icetech.user.domain.entity.user.UserDefultAisle;
import com.icetech.user.domain.vo.SaasCsUserVo;
import com.icetech.user.service.SaasInstitutionService;
import java.security.Key;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="userService")
public class UserServiceImpl
implements UserService {
    private static final Logger log = LoggerFactory.getLogger(UserServiceImpl.class);
    private static final String ROLE_NAME1 = "\u4e91\u5c97\u4ead\u7ba1\u7406\u5458";
    private static final String ROLE_NAME2 = "\u4e2d\u592e\u6536\u8d39\u5458";
    private static final String ROLE_NAME3 = "\u667a\u6167\u505c\u8f66\u4e91\u5750\u5e2d";
    private static final String ROLE_NAME4 = "\u4e91\u8c03\u8bd5\u52a9\u624b";
    private static final String ROLE_NAME5 = "\u7cfb\u7edf\u7ba1\u7406\u5458";
    private static final String ROLE_NAME6 = "\u8f66\u573a\u7ba1\u7406\u5458";
    private static final String ROLE_NAME7 = "\u5c97\u4ead\u6536\u8d39\u5458";
    public static final String SECRET_KEY = "ZocNQD0mdfcmMKEWmtISpQ==";
    public static final String INIT_VECTOR = "Aocade0xxermMKEW";
    public static final String REGEX = "^(?=.*[a-zA-Z])(?=.*\\d).{8,16}$";
    public static final String SALT = "guokong";
    @Autowired
    private SaasUserDao saasUserDao;
    @Autowired
    private MpUserDao mpUserDao;
    @Autowired
    private UserDefultAisleDao userDefultAisleDao;
    @Autowired
    private ParkService parkService;
    @Autowired
    private SaasInstitutionService saasInstitutionService;
    @Autowired
    private SaasUserParkService saasUserParkService;

    public ObjectResponse<SaasUserDto> carManagerLogin(String userName, String password, String newPwd, Integer from) {
        try {
            boolean allowLogin;
            List<String> permitRoleNames;
            SaasUser saasUser = this.saasUserDao.selectByUserName(userName);
            if (Objects.isNull(saasUser) || !saasUser.getUsername().equals(userName)) {
                return ObjectResponse.failed((String)CodeConstantsEnum.ERROR_404.getCode(), (String)"\u7528\u6237\u4e0d\u5b58\u5728");
            }
            SaasUserDto saasUserDto = new SaasUserDto();
            BeanUtils.copyProperties((Object)saasUser, (Object)saasUserDto);
            saasUserDto.setUpdateFlag(Integer.valueOf(0));
            saasUserDto.setFrom(from);
            if (!StringUtils.isBlank((CharSequence)newPwd)) {
                String decryptPwd = UserServiceImpl.decrypt(newPwd);
                if (StringUtils.isEmpty((CharSequence)decryptPwd)) {
                    return ObjectResponse.failed((String)"1000", (String)"\u5bc6\u7801\u9519\u8bef");
                }
                if (decryptPwd.length() < 8 || decryptPwd.length() > 16 || !decryptPwd.matches(REGEX)) {
                    saasUserDto.setUpdateFlag(Integer.valueOf(1));
                }
                if (!DigestUtils.md5Hex((String)(decryptPwd + SALT)).equalsIgnoreCase(saasUser.getPassword())) {
                    return ObjectResponse.failed((String)"1000", (String)"\u7528\u6237\u540d\u6216\u5bc6\u7801\u9519\u8bef");
                }
            } else if (!DigestUtils.md5Hex((String)(password + SALT)).equalsIgnoreCase(saasUser.getPassword())) {
                return ObjectResponse.failed((String)"1000", (String)"\u7528\u6237\u540d\u6216\u5bc6\u7801\u9519\u8bef");
            }
            String roleName = this.saasUserDao.getRoleName(saasUser.getRoleId());
            saasUserDto.setRoleName(roleName);
            if (from == null || from == 2) {
                permitRoleNames = Arrays.asList(ROLE_NAME1, ROLE_NAME4, ROLE_NAME6);
                if (!permitRoleNames.contains(roleName)) {
                    return ObjectResponse.failed((String)CodeConstantsEnum.ERROR_401.getCode(), (String)"\u5f53\u524d\u89d2\u8272\u4e0d\u5141\u8bb8\u767b\u9646");
                }
                if (roleName.equals(ROLE_NAME1)) {
                    saasUserDto.setFrom(Integer.valueOf(2));
                }
                if (roleName.equals(ROLE_NAME4)) {
                    saasUserDto.setFrom(Integer.valueOf(5));
                }
            } else if (from == 3) {
                if (StringUtils.isEmpty((CharSequence)roleName) || !roleName.equals(ROLE_NAME2)) {
                    return ObjectResponse.failed((String)CodeConstantsEnum.ERROR_401.getCode(), (String)"\u5f53\u524d\u89d2\u8272\u4e0d\u5141\u8bb8\u767b\u9646");
                }
            } else if (from == 4) {
                if (StringUtils.isEmpty((CharSequence)roleName) || !roleName.equals(ROLE_NAME3)) {
                    return ObjectResponse.failed((String)CodeConstantsEnum.ERROR_401.getCode(), (String)"\u5f53\u524d\u89d2\u8272\u4e0d\u5141\u8bb8\u767b\u9646");
                }
                UserDefultAisle userDefultAisle = this.userDefultAisleDao.selectByUserId(saasUser.getId());
                saasUserDto.setIsDefault(Integer.valueOf(2));
                if (!Objects.isNull(userDefultAisle) && StringUtils.isNotEmpty((CharSequence)userDefultAisle.getAisleCode())) {
                    saasUserDto.setIsDefault(Integer.valueOf(1));
                }
            } else if (from == 5 ? !(permitRoleNames = Arrays.asList(ROLE_NAME6, ROLE_NAME7)).contains(roleName) : from == 6 && !(permitRoleNames = Arrays.asList(ROLE_NAME1, ROLE_NAME5, ROLE_NAME6, SaasUserDto.RoleEnum.ROLE_NAME7.getRoleName())).contains(roleName)) {
                return ObjectResponse.failed((String)CodeConstantsEnum.ERROR_401.getCode(), (String)"\u5f53\u524d\u89d2\u8272\u4e0d\u5141\u8bb8\u767b\u9646");
            }
            if (from != null && (from == 2 || from == 5 || from == 6) && roleName.equals(ROLE_NAME6) && !(allowLogin = this.parkManagerLoginValidate(saasUser.getLoginPortType(), from))) {
                return ObjectResponse.failed((String)"401", (String)"\u5f53\u524d\u89d2\u8272\u4e0d\u5141\u8bb8\u767b\u9646");
            }
            return ObjectResponse.success((Object)saasUserDto);
        }
        catch (Exception e) {
            log.error("[\u8f66\u573a\u7ba1\u5bb6\u767b\u9646\u63a5\u53e3\u5f02\u5e38],{}", (Object)e.getMessage());
            return ObjectResponse.failed((String)CodeConstantsEnum.ERROR.getCode(), (String)CodeConstantsEnum.ERROR.getDesc());
        }
    }

    public ObjectResponse<SaasUserDto> carManagerLogin(String userName, String password) {
        return this.carManagerLogin(userName, password, "1xxxxxxxxx", 2);
    }

    public ObjectResponse updatePassWord(Integer userId, String oldPwd, String newPwd, String updateOldPwd, String updateNewPwd) {
        try {
            SaasUser saasUser = this.saasUserDao.load(userId);
            if (Objects.isNull(saasUser)) {
                return ObjectResponse.failed((String)CodeConstantsEnum.ERROR_404.getCode(), (String)"\u7528\u6237\u4e0d\u5b58\u5728");
            }
            if (StringUtils.isNotBlank((CharSequence)updateOldPwd) && StringUtils.isNotBlank((CharSequence)updateNewPwd)) {
                String decryptPwd = UserServiceImpl.decrypt(updateOldPwd);
                if (StringUtils.isEmpty((CharSequence)decryptPwd)) {
                    return ObjectResponse.failed((String)"1000", (String)"\u5bc6\u7801\u9519\u8bef");
                }
                if (!DigestUtils.md5Hex((String)(decryptPwd + SALT)).equalsIgnoreCase(saasUser.getPassword())) {
                    return ObjectResponse.failed((String)"1000", (String)"\u7528\u6237\u540d\u6216\u5bc6\u7801\u9519\u8bef");
                }
                String decryptNewPwd = UserServiceImpl.decrypt(updateNewPwd);
                if (StringUtils.isEmpty((CharSequence)decryptNewPwd)) {
                    return ObjectResponse.failed((String)"1000", (String)"\u5bc6\u7801\u9519\u8bef");
                }
                if (decryptNewPwd.length() < 8 || decryptNewPwd.length() > 16) {
                    return ObjectResponse.failed((String)"1000", (String)"\u8bf7\u8f93\u51658-16\u4f4d\u5bc6\u7801");
                }
                boolean flag = decryptNewPwd.matches(REGEX);
                if (!flag) {
                    return ObjectResponse.failed((String)"1000", (String)"\u5bc6\u7801\u9700\u5305\u542b\u5b57\u6bcd\u548c\u6570\u5b57\uff0c\u957f\u5ea6\u57288-16\u4e4b\u95f4");
                }
                saasUser.setPassword(DigestUtils.md5Hex((String)(decryptNewPwd + SALT)));
            } else {
                if (!DigestUtils.md5Hex((String)(oldPwd + SALT)).equalsIgnoreCase(saasUser.getPassword())) {
                    return ObjectResponse.failed((String)CodeConstantsEnum.ERROR_402.getCode(), (String)"\u7528\u6237\u540d\u6216\u5bc6\u7801\u9519\u8bef");
                }
                saasUser.setPassword(DigestUtils.md5Hex((String)(newPwd + SALT)));
            }
            this.saasUserDao.update(saasUser);
            return ObjectResponse.success();
        }
        catch (Exception e) {
            log.error("[\u8f66\u573a\u7ba1\u5bb6\u4fee\u6539\u5bc6\u7801\u63a5\u53e3\u5f02\u5e38],{}", (Object)e.getMessage());
            return ObjectResponse.failed((String)CodeConstantsEnum.ERROR.getCode(), (String)CodeConstantsEnum.ERROR.getDesc());
        }
    }

    public ObjectResponse updatePassWord(Integer userId, String newPwd) {
        try {
            SaasUser saasUser = this.saasUserDao.load(userId);
            if (Objects.isNull(saasUser)) {
                return ObjectResponse.failed((String)CodeConstantsEnum.ERROR_404.getCode(), (String)"\u7528\u6237\u4e0d\u5b58\u5728");
            }
            saasUser.setPassword(DigestUtils.md5Hex((String)(newPwd + SALT)));
            this.saasUserDao.update(saasUser);
            return ObjectResponse.success();
        }
        catch (Exception e) {
            log.error("[\u8f66\u4e3b\u7aef\u91cd\u7f6e\u5bc6\u7801\u63a5\u53e3\u5f02\u5e38],{}", (Object)e.getMessage());
            return ObjectResponse.failed((String)CodeConstantsEnum.ERROR.getCode(), (String)CodeConstantsEnum.ERROR.getDesc());
        }
    }

    public boolean parkManagerLoginValidate(String loginPortType, Integer from) {
        if (StringUtils.isBlank((CharSequence)loginPortType)) {
            return false;
        }
        List<String> loginPortTypeList = Arrays.asList(loginPortType.split(","));
        boolean allowLogin = false;
        switch (from) {
            case 2: {
                if (!loginPortTypeList.contains(String.valueOf(4))) break;
                allowLogin = true;
                break;
            }
            case 5: {
                if (!loginPortTypeList.contains(String.valueOf(3))) break;
                allowLogin = true;
                break;
            }
            case 6: {
                if (!loginPortTypeList.contains(String.valueOf(2))) break;
                allowLogin = true;
                break;
            }
        }
        return allowLogin;
    }

    public ObjectResponse<SaasUserDto> getUserDetail(Integer userId) {
        SaasUser saasUser = this.saasUserDao.load(userId);
        if (Objects.isNull(saasUser)) {
            return ObjectResponse.failed((String)CodeConstantsEnum.ERROR_404.getCode(), (String)"\u7528\u6237\u4e0d\u5b58\u5728");
        }
        SaasUserDto saasUserDto = new SaasUserDto();
        BeanUtils.copyProperties((Object)saasUser, (Object)saasUserDto);
        saasUserDto.setImgUrl("https://timgsa.baidu.com/timg?image&quality=80&size=b9999_10000&sec=1556084581720&di=5133ea34ece400be9f5b69341fb0d945&imgtype=0&src=http%3A%2F%2Fimg.zcool.cn%2Fcommunity%2F01786557e4a6fa0000018c1bf080ca.png");
        return ObjectResponse.success((Object)saasUserDto);
    }

    public ObjectResponse<MpUser> mpLogin(String mobile, String openId) {
        MpUser mpUser = null;
        if (StringUtils.isNotEmpty((CharSequence)mobile)) {
            mpUser = this.mpUserDao.selectByMobile(mobile, null, null);
        }
        if (Objects.isNull(mpUser)) {
            mpUser = this.mpUserDao.selectByMobile(null, openId, null);
        }
        if (Objects.isNull(mpUser)) {
            mpUser = new MpUser();
            mpUser.setMobile(mobile);
            mpUser.setOpenId(openId);
            mpUser.setCreateTime(new Date());
            this.mpUserDao.insert(mpUser);
        } else {
            mpUser.setUpdateTime(new Date());
            mpUser.setMobile(mobile);
            mpUser.setOpenId(openId);
            this.mpUserDao.update(mpUser);
        }
        return ObjectResponse.success((Object)mpUser);
    }

    public ObjectResponse<MpUser> mpLogin(String mobile, String openId, String miniOpenId) {
        MpUser mpUser = StringUtils.isNotBlank((CharSequence)mobile) ? this.mpUserDao.selectByMobile(mobile, null, null) : this.mpUserDao.selectByMobile(mobile, openId, miniOpenId);
        if (Objects.isNull(mpUser)) {
            mpUser = new MpUser();
            mpUser.setMobile(mobile);
            mpUser.setOpenId(openId);
            mpUser.setMiniOpenId(miniOpenId);
            mpUser.setCreateTime(new Date());
            this.mpUserDao.insert(mpUser);
        } else {
            mpUser.setUpdateTime(new Date());
            if (StrUtil.isNotBlank((CharSequence)mobile)) {
                mpUser.setMobile(mobile);
            }
            if (StrUtil.isNotBlank((CharSequence)openId)) {
                mpUser.setOpenId(openId);
            }
            if (StrUtil.isNotBlank((CharSequence)miniOpenId)) {
                mpUser.setMiniOpenId(miniOpenId);
            }
            this.mpUserDao.update(mpUser);
        }
        return ObjectResponse.success((Object)mpUser);
    }

    public ObjectResponse<List<String>> getMpUserBindPlateNum(Integer id) {
        List<String> plateNums = this.mpUserDao.selectPlateNumByUserId(id);
        if (CollectionUtils.isEmpty(plateNums)) {
            return ObjectResponse.failed((CodeConstantsEnum)CodeConstantsEnum.ERROR_404);
        }
        return ObjectResponse.success(plateNums);
    }

    public ObjectResponse addMpUserBindPlateNum(Integer mpUserId, String plateNum) {
        Integer count = this.mpUserDao.verifyPlateNum(plateNum);
        if (count > 0) {
            return ObjectResponse.failed((String)CodeConstantsEnum.ERROR_402.getCode(), (String)"\u8f66\u724c\u5df2\u7ecf\u88ab\u7ed1\u5b9a");
        }
        MpUserPlate mpUserPlate = new MpUserPlate();
        mpUserPlate.setMpUserId(mpUserId);
        mpUserPlate.setPlateNum(plateNum);
        this.mpUserDao.insertBind(mpUserPlate);
        return ObjectResponse.success();
    }

    public ObjectResponse deleteMpUserBindPlateNum(Integer mpUserId, String plateNum) {
        this.mpUserDao.deleteBind(mpUserId, plateNum);
        return ObjectResponse.success();
    }

    public ObjectResponse<SaasUserDto> getUserByName(String userName) {
        SaasUser saasUser = this.saasUserDao.selectByUserName(userName);
        if (Objects.isNull(saasUser)) {
            return ObjectResponse.failed((String)CodeConstantsEnum.ERROR_404.getCode(), (String)"\u7528\u6237\u4e0d\u5b58\u5728");
        }
        String roleName = this.saasUserDao.getRoleName(saasUser.getRoleId());
        if (!SaasUserDto.isModify((String)roleName).booleanValue()) {
            return ObjectResponse.failed((String)CodeConstantsEnum.ERROR_404.getCode(), (String)"\u7528\u6237\u4e0d\u5b58\u5728");
        }
        SaasUserDto saasUserDto = new SaasUserDto();
        BeanUtils.copyProperties((Object)saasUser, (Object)saasUserDto);
        return ObjectResponse.success((Object)saasUserDto);
    }

    public ObjectResponse<SaasUserDto> getUserByUserName(String userName) {
        SaasUser saasUser = this.saasUserDao.selectUserName(userName);
        if (Objects.isNull(saasUser)) {
            return ObjectResponse.failed((String)CodeConstantsEnum.ERROR_404.getCode(), (String)"\u7528\u6237\u4e0d\u5b58\u5728");
        }
        SaasUserDto saasUserDto = new SaasUserDto();
        BeanUtils.copyProperties((Object)saasUser, (Object)saasUserDto);
        return ObjectResponse.success((Object)saasUserDto);
    }

    public ObjectResponse<MpUser> getMpUserByPlateNum(String plateNum) {
        MpUser mpUser = this.mpUserDao.selectOpenIdByPlateNum(plateNum);
        return ObjectResponse.returnNotFoundIfNull((Object)mpUser);
    }

    public ObjectResponse<SaasUser> getSaasUserBySeatNum(String seatNumber) {
        return ObjectResponse.returnNotFoundIfNull((Object)this.saasUserDao.selectBySeatNum(seatNumber));
    }

    public ObjectResponse<List<SaasUser>> getSaasUserByIds(List<Long> userIds) {
        return ObjectResponse.success(this.saasUserDao.selectByIds(userIds));
    }

    public ObjectResponse<List<SaasUser>> getSaasCsUserByIds(List<Long> userIds) {
        return null;
    }

    public ObjectResponse<List<SaasCsUserVo>> getCsUserByPark(String parkCode) {
        ObjectResponse byParkCode = this.parkService.findByParkCode(parkCode);
        SaasInstitution saasInstitution = this.saasInstitutionService.getSaasInstitutionById(((Park)byParkCode.getData()).getInstitutionId().longValue());
        HashSet userIds = Sets.newHashSet();
        if (Objects.nonNull(saasInstitution)) {
            List<SaasUser> saasUsers;
            List saasUserParks;
            List institutionIds = Arrays.stream(saasInstitution.getCode().split(",")).filter(StringUtils::isNotBlank).map(Integer::parseInt).collect(Collectors.toList());
            List saasUserParkByInstitutionIds = this.saasUserParkService.getSaasUserParkByInstitutionIds(institutionIds);
            if (CollectionUtils.isNotEmpty((Collection)saasUserParkByInstitutionIds)) {
                saasUserParkByInstitutionIds.forEach(saasUserPark -> userIds.add(saasUserPark.getUserId()));
            }
            if (CollectionUtils.isNotEmpty((Collection)(saasUserParks = this.saasUserParkService.listByParkId(((Park)byParkCode.getData()).getId())))) {
                saasUserParks.forEach(saasUserPark -> userIds.add(saasUserPark.getUserId()));
            }
            if (CollectionUtils.isNotEmpty((Collection)userIds) && CollectionUtils.isNotEmpty(saasUsers = this.saasUserDao.selectCsByIds(userIds))) {
                List saasCsUserVos = saasUsers.stream().map(saasUser -> {
                    SaasCsUserVo saasCsUserVo = new SaasCsUserVo();
                    BeanUtils.copyProperties((Object)saasUser, (Object)saasCsUserVo);
                    return saasCsUserVo;
                }).collect(Collectors.toList());
                return ObjectResponse.success(saasCsUserVos);
            }
        }
        return ObjectResponse.success((Object)Lists.newArrayList());
    }

    public ObjectResponse<SaasUserDto> haiDaCarManagerLogin(String userName, String password, Integer from) {
        try {
            SaasUser saasUser = this.saasUserDao.selectByUserName(userName);
            if (Objects.isNull(saasUser) || !saasUser.getUsername().equals(userName)) {
                return ObjectResponse.failed((String)CodeConstantsEnum.ERROR_404.getCode(), (String)"\u7528\u6237\u4e0d\u5b58\u5728");
            }
            SaasUserDto saasUserDto = new SaasUserDto();
            BeanUtils.copyProperties((Object)saasUser, (Object)saasUserDto);
            saasUserDto.setFrom(from);
            if (!DigestUtils.md5Hex((String)(password + SALT)).equalsIgnoreCase(saasUser.getPassword())) {
                return ObjectResponse.failed((String)CodeConstantsEnum.ERROR_401.getCode(), (String)"\u7528\u6237\u540d\u6216\u5bc6\u7801\u9519\u8bef");
            }
            String roleName = this.saasUserDao.getRoleName(saasUser.getRoleId());
            saasUserDto.setRoleName(roleName);
            if (!SaasUserDto.RoleEnum.ROLE_NAME8.getRoleName().equals(roleName)) {
                return ObjectResponse.failed((String)CodeConstantsEnum.ERROR_401.getCode(), (String)"\u5f53\u524d\u89d2\u8272\u4e0d\u5141\u8bb8\u767b\u9646");
            }
            return ObjectResponse.success((Object)saasUserDto);
        }
        catch (Exception e) {
            log.error("[\u8f66\u573a\u7ba1\u5bb6\u767b\u9646\u63a5\u53e3\u5f02\u5e38],{}", (Object)e.getMessage());
            return ObjectResponse.failed((String)CodeConstantsEnum.ERROR.getCode(), (String)CodeConstantsEnum.ERROR.getDesc());
        }
    }

    public static String decrypt(String encrypted) {
        try {
            SecretKeySpec key = new SecretKeySpec(SECRET_KEY.getBytes("UTF-8"), "AES");
            IvParameterSpec iv = new IvParameterSpec(INIT_VECTOR.getBytes("UTF-8"));
            Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5PADDING");
            cipher.init(2, (Key)key, iv);
            byte[] original = cipher.doFinal(Base64.getDecoder().decode(encrypted));
            return new String(original);
        }
        catch (Exception e) {
            log.error("[\u767b\u5f55]\u89e3\u5bc6\u5931\u8d25,\u9519\u8bef\u4fe1\u606f{}", (Object)e.getMessage());
            return "";
        }
    }
}

