package com.icetech.third.service.third;

import javax.annotation.Resource;

import com.icetech.cloudcenter.api.third.ThirdTeldParkService;
import com.icetech.third.dao.third.ThirdTeldParkDao;
import com.icetech.third.domain.entity.third.ThirdTeldPark;
import com.icetech.common.domain.response.ObjectResponse;
import org.springframework.stereotype.Service;

@Service
public class ThirdTeldParkServiceImpl implements ThirdTeldParkService {
    @Resource
    private ThirdTeldParkDao thirdTeldParkDao;

    @Override
    public ObjectResponse<ThirdTeldPark> getConfigByParkId(long parkId) {
        ThirdTeldPark park = thirdTeldParkDao.getByParkId(parkId);
        return ObjectResponse.returnNotFoundIfNull(park);
    }

    @Override
    public ObjectResponse<ThirdTeldPark> getConfigByParkCode(String parkCode) {
        ThirdTeldPark park = thirdTeldParkDao.getByParkCode(parkCode);
        return ObjectResponse.returnNotFoundIfNull(park);
    }
}
