package com.icetech.third.service.third;


import com.icetech.cloudcenter.api.third.ThirdParkService;
import com.icetech.third.dao.third.ThirdParkDao;
import com.icetech.third.domain.entity.third.ThirdInfo;
import com.icetech.third.domain.entity.third.ThirdPark;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

/**
 * 第三方与车场关联信息DAO
 * @author fangct
 */
@Service
@Slf4j
public class ThirdParkServiceImpl implements ThirdParkService {
    @Autowired
    private ThirdParkDao thirdParkDao;

    @Override
    public ThirdPark selectByParkId(Long parkId){
        return thirdParkDao.selectByParkId(parkId);
    }

    /**
     * 根据车场ID查询第三方信息
     * @param parkId
     * @return
     */
    @Override
    public List<ThirdInfo> selectThirdByParkId(Long parkId){
        return thirdParkDao.selectThirdByParkId(parkId);
    }

    @Override
    public ThirdInfo selectThirdByParkIdPID(Long parkId, String pid){
        return thirdParkDao.selectThirdByParkIdPID(parkId, pid);
    }

    @Override
    public List<Long> selectParkByPid(String pid){
        return thirdParkDao.selectParkByPid(pid);
    }

    @Override
    public boolean checkPermissionService(long parkId, String serviceName) {
        List<String> services = thirdParkDao.selectPermissionServicesByParkId(parkId);
        Set<String> serviceNames = services.stream().flatMap(service -> Stream.of(service.split(","))).collect(Collectors.toSet());
        return serviceNames.contains(serviceName);
    }
    @Override
    public Integer insertInfoByThird(ThirdPark thirdPark) {
        return thirdParkDao.insertInfoByThird(thirdPark);
    }

    @Override
    public ThirdInfo selectNoSenConfig(Long parkId) {
        return thirdParkDao.selectNoSenConfig(parkId);
    }

    @Override
    public List<ThirdInfo> selectNoSenConfigs(Long parkId) {
        return thirdParkDao.selectNoSenConfigs(parkId);
    }

    @Override
    public Integer deleteByIds(List<Integer> ids) {
        return thirdParkDao.deleteByIds(ids);
    }

    @Override
    public List<ThirdPark> findAllByParkId(Long parkId) {
        return thirdParkDao.findAllByParkId(parkId);
    }

    @Override
    public List<ThirdInfo> selectThirdByParkIdAndService(Long parkId, String serviceName) {
        return thirdParkDao.selectThirdByParkIdAndService(parkId, serviceName);
    }
}
