package com.icetech.third.service.third;


import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.icetech.cloudcenter.api.park.ParkService;
import com.icetech.cloudcenter.api.third.ThirdAttributeService;
import com.icetech.cloudcenter.api.third.ThirdInfoService;
import com.icetech.cloudcenter.api.third.ThirdParamService;
import com.icetech.cloudcenter.api.third.ThirdParkRefService;
import com.icetech.cloudcenter.domain.response.ThirdParkInfoResponse;
import com.icetech.common.constants.CodeConstants;
import com.icetech.common.constants.CodeConstantsEnum;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.park.domain.entity.park.Park;
import com.icetech.park.domain.entity.park.ThirdParkMessage;
import com.icetech.redis.handle.RedisHandle;
import com.icetech.third.dao.third.ThirdInfoDao;
import com.icetech.third.dao.third.ThirdParkDao;
import com.icetech.third.domain.entity.third.*;
import com.icetech.third.service.ThirdTongchengParkChannelService;
import com.icetech.third.service.ThirdTongchengParkService;
import com.icetech.third.service.extend.PushExtendService;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;
import java.util.Objects;

/**
 * 第三方信息DAO
 * @author fangct
 */
@Service
@Slf4j
public class ThirdInfoServiceImpl implements ThirdInfoService {
    @Autowired
    private ThirdInfoDao thirdInfoDao;
    @Autowired
    private ThirdParkDao thirdParkDao;

    @Autowired
    private PushExtendService pushExtendService;

    @Autowired
    private ThirdParkRefService thirdParkRefService;

    @Value("${abjh.appid}")
    private String appId;

    @Autowired
    private ParkService parkService;

    @Autowired
    private ThirdAttributeService thirdAttributeService;

    @Autowired
    private ThirdParamService thirdParamService;

    /**
     * 标识 正确
     */
    private final Integer isSuccess = 1;

    /**
     * 三方支付链接
     */
    private final Integer THIRD_FEE = 1;
    /**
     * 三方二维码配置
     */
    private final Integer THIRD_QR = 2;

    @Autowired
    private ThirdBstParkService thirdBstParkService;

    @Autowired
    private BstAdSpaceService bstAdSpaceService;

    @Resource
    private RedisHandle redisHandle;

    /**
     * 泊斯特广告位缓冲key
     */
    public static final String BST_SPACE_KEY = "bst:park:space:";

    @Autowired
    private ThirdTongchengParkService thirdTongchengParkService;
    @Autowired
    private ThirdTongchengParkChannelService tongchengParkChannelService;


    @Override
    public List<ThirdParkInfoResponse> selectByPid(String pid){
        return thirdInfoDao.selectByPid(pid);
    }

    @Override
    public ObjectResponse<ThirdInfo> selectThirdInfo(String pid) {
        ThirdInfo thirdInfo = new ThirdInfo();
        thirdInfo.setPid(pid);
        thirdInfo = thirdInfoDao.selectById(thirdInfo);
        if (Objects.nonNull(thirdInfo)){
            return ObjectResponse.success(thirdInfo);
        }
        return  ObjectResponse.failed(CodeConstantsEnum.ERROR_404);
    }

    @Override
    public ThirdInfo selectById(ThirdInfo para) {
        return thirdInfoDao.selectById(para);
    }

    @Override
    public ThirdInfo selectParkThirdConf(Long parkId,String pId) {
        return thirdParkDao.selectThirdByParkIdPID(parkId,pId);
    }

    /**
     * 检查三方对接权限内容
     * @param parkId
     * @param serviceName
     * @return
     */
    @Override
    public Integer checkOpenPushAccount(Long parkId, String serviceName) {
        return thirdParkDao.checkOpenPushAccount(parkId,serviceName);
    }

    /**
     * 获取三方计费链接
     *
     * @param parkId
     * @return
     */
    @Override
    public ThirdInfo getThirdFeeUrl(Long parkId) {
        return getThirdConfig(parkId,THIRD_FEE);
    }



    /**
     * 获取三方二维码地址
     *
     * @param parkId
     * @return
     */
    @Override
    public ThirdInfo getThirdQrUrl(Long parkId) {
        return getThirdConfig(parkId,THIRD_QR);
    }

    @Override
    public ThirdInfo getThirdAdvice(Long parkId) {
        ThirdInfo thirdInfoFind = null;
        List<ThirdInfo> thirdInfoList = thirdParkDao.selectThirdByParkId(parkId);
        log.info("[获取三方配置]  [{}]",thirdInfoList);
        if (Objects.nonNull(thirdInfoList)) {
            for (ThirdInfo thirdInfo : thirdInfoList) {
                if (isSuccess.equals(thirdInfo.getIsThirdAdvice())) {
                    thirdInfoFind = thirdInfo;
                    break;
                }
            }
        }
        return thirdInfoFind;
    }

    @Override
    public Boolean updateParams(String params, Integer id) {
        return thirdInfoDao.updateParamsById(params, id) > 0;
    }

    @Override
    public Boolean addPushExtend(PushExtend pushExtend) {
        return pushExtendService.save(pushExtend);
    }

    @Override
    public Boolean deletePushExtendById(Long id) {
        return pushExtendService.removeById(id);
    }

    @Override
    public PushExtend getPushExtend(Long parkId, String plateNum, Long enterTime) {
        return pushExtendService.selectLimitOne(PushExtend.builder()
                .parkId(parkId)
                .plateNum(plateNum)
                .enterTime(enterTime)
                .build());
    }

    @Override
    public Integer addThirdInfo(ThirdInfo thirdInfo) {
        return thirdInfoDao.insert(thirdInfo);
    }

    private ThirdInfo getThirdConfig(Long parkId, Integer type) {
        ThirdInfo thirdInfoFind = null;
        List<ThirdInfo> thirdInfoList = thirdParkDao.selectThirdByParkId(parkId);
        if (Objects.nonNull(thirdInfoList)) {
            for (ThirdInfo thirdInfo : thirdInfoList) {
                if (THIRD_FEE.equals(type) && isSuccess.equals(thirdInfo.getIsThirdFee())) {
                    thirdInfoFind = thirdInfo;
                    break;
                }
                if (THIRD_QR.equals(type) && isSuccess.equals(thirdInfo.getIsThirdPay())) {
                    thirdInfoFind = thirdInfo;
                    break;
                }
            }
        }
        return thirdInfoFind;
    }

    @Override
    public ThirdParkMessage getThirdParkMessageBy(Long parkId) {
        ThirdParkRef thirdParkRef = thirdParkRefService.selectLimitOne(ThirdParkRef.builder()
                .parkId(parkId)
                .build());
        if (thirdParkRef == null) {
            return null;
        }
        return ThirdParkMessage.builder()
                .thirdParkId(thirdParkRef.getThirdParkId())
                .appId(appId)
                .build();
    }

    @Override
    public ObjectResponse<List<ThirdAttribute>> getThirdAttribute(Long thirdId) {
        List<ThirdAttribute> attributes = thirdAttributeService.list(Wrappers.lambdaQuery(ThirdAttribute.class)
                .eq(ThirdAttribute::getThirdId, thirdId)
                .eq(ThirdAttribute::getDeleted, 0)
                .orderByAsc(ThirdAttribute::getSortNum));
        return CollectionUtils.isEmpty(attributes) ? ObjectResponse.failed(CodeConstantsEnum.ERROR_404) : ObjectResponse.success(attributes);
    }

    @Override
    public ObjectResponse<ThirdParam> getParkThirdParam(Long parkId, Long thirdId) {
        ThirdParam thirdParam = thirdParamService.selectLimitOne((Wrappers.lambdaQuery(ThirdParam.class)
                .eq(ThirdParam::getParkId, parkId)
                .eq(ThirdParam::getThirdId, thirdId)
                .eq(ThirdParam::getDeleted, 0)));
        if (thirdParam == null) {
            return ObjectResponse.failed(CodeConstantsEnum.ERROR_404);
        }
        return ObjectResponse.success(thirdParam);
    }


    @Override
    public ObjectResponse<ThirdParam> addParkThirdParam(ThirdParam params) {
        return thirdParamService.save(params) ? ObjectResponse.success(params) : ObjectResponse.failed(CodeConstantsEnum.ERROR_404);
    }

    @Override
    public ObjectResponse<ThirdParam> getPakThirdParamBy(Long id) {
        ThirdParam thirdParam = thirdParamService.selectLimitOne(Wrappers.lambdaQuery(ThirdParam.class)
                .eq(ThirdParam::getId, id)
                .eq(ThirdParam::getDeleted, 0));
        if (thirdParam == null) {
            return ObjectResponse.failed();
        }
        return ObjectResponse.success(thirdParam);
    }

    @Override
    public ObjectResponse<ThirdParam> updateParkThirdParams(ThirdParam thirdParam) {
        return thirdParamService.updateById(thirdParam) ? ObjectResponse.success(thirdParam) : ObjectResponse.failed(CodeConstantsEnum.ERROR_404);
    }

    @Override
    public ObjectResponse<com.icetech.common.domain.Page<ThirdParam>> getThirdParkPage(Long thirdId, Integer pageNo, Integer pageSize, Long parkId) {
        IPage<ThirdParam> page = new Page<>();
        page.setCurrent(pageNo);
        page.setSize(pageSize);
        LambdaQueryWrapper<ThirdParam> queryWrapper = Wrappers.lambdaQuery(ThirdParam.class);
        queryWrapper.eq(ThirdParam::getThirdId, thirdId);
        if (Objects.nonNull(parkId)) {
            queryWrapper.eq(ThirdParam::getParkId, parkId);
        }
        queryWrapper.orderByDesc(ThirdParam::getUpdateTime);
        IPage<ThirdParam> result = thirdParamService.page(page,queryWrapper);
        return ObjectResponse.success(com.icetech.common.domain.Page.instance(Math.toIntExact(result.getPages()), result.getTotal(), result.getRecords()));
    }

    @Override
    public ObjectResponse<List<ThirdParam>> getThirdParamsByThirdId(Long thirdId) {
        List<ThirdParam> params = thirdParamService.list(Wrappers.lambdaQuery(ThirdParam.class)
                .eq(ThirdParam::getThirdId, thirdId)
                .eq(ThirdParam::getDeleted, 0));
        return CollectionUtils.isEmpty(params) ? ObjectResponse.failed(CodeConstantsEnum.ERROR_404) : ObjectResponse.success(params);
    }

    @Override
    public ObjectResponse<Void> addThirdBstPark(ThirdBstPark thirdBstPark) {
        thirdBstParkService.addThirdBstPark(thirdBstPark);
        return ObjectResponse.success();
    }

    @Override
    public ObjectResponse<Void> batchSaveBstParkSpace(List<BstAdSpace> bstAdSpaces) {
        bstAdSpaceService.saveBatch(bstAdSpaces);
        return ObjectResponse.success();
    }

    @Override
    public ObjectResponse<BstAdSpace> getBstAdSpace(String parkCode, Integer deviceType, Integer triggerEvent) {
        String cacheKey = BST_SPACE_KEY + parkCode + ":" + deviceType + ":" + triggerEvent;
        BstAdSpace bstAdSpace = redisHandle.cacheObject(cacheKey, BstAdSpace.class, () -> bstAdSpaceService.selectLimitOne(BstAdSpace.builder()
                .parkCode(parkCode)
                .deviceType(deviceType)
                .triggerEvent(triggerEvent)
                .build()), 86400000L);
        if (bstAdSpace == null) {
            return ObjectResponse.failed(CodeConstants.ERROR_404);
        }
        return ObjectResponse.success(bstAdSpace);
    }


    @Override
    public ObjectResponse<ThirdTongchengPark> selectTongchengPark(String parkNo) {
        ThirdTongchengPark tongchengPark = thirdTongchengParkService.getThirdTongchengParkByThirdIdAndParkNo(parkNo);
        if (Objects.nonNull(tongchengPark)){
            return ObjectResponse.success(tongchengPark);
        }
        return ObjectResponse.failed(CodeConstantsEnum.ERROR_404);
    }

    @Override
    public ObjectResponse<ThirdTongchengPark> selectTongchengParkCode(String parkCode) {
        ThirdTongchengPark tongchengPark = thirdTongchengParkService.getThirdTongchengParkByThirdIdAndParkCode(parkCode);
        if (Objects.nonNull(tongchengPark)){
            return ObjectResponse.success(tongchengPark);
        }
        return ObjectResponse.failed(CodeConstantsEnum.ERROR_404);
    }

    @Override
    public ObjectResponse<ThirdInfo> selectThirdByTongchengPark(String parkNo){
        ThirdTongchengPark tongchengPark = thirdTongchengParkService.getThirdTongchengParkByThirdIdAndParkNo(parkNo);
        if (Objects.isNull(tongchengPark)){
            return ObjectResponse.failed(CodeConstantsEnum.ERROR_404);
        }
        ThirdInfo thirdInfo = new ThirdInfo();
        thirdInfo.setId(tongchengPark.getThirdId());
        thirdInfo = thirdInfoDao.selectById(thirdInfo);
        if (Objects.nonNull(thirdInfo)){
            return ObjectResponse.success(thirdInfo);
        }
        return ObjectResponse.failed(CodeConstantsEnum.ERROR_404);
    }

    @Override
    public ObjectResponse<ThirdTongchengParkChannel> selectTongchengParkChannel(String parkNo, String chNo) {
        ObjectResponse<ThirdTongchengPark> thirdTongchengParkObjectResponse = selectTongchengPark(parkNo);
        if (ObjectResponse.isSuccess(thirdTongchengParkObjectResponse)){
            ThirdTongchengPark tongchengPark = thirdTongchengParkObjectResponse.getData();
            ThirdTongchengParkChannel thirdTongchengParkChannel = tongchengParkChannelService.getThirdTongchengParkChannelByChNo(tongchengPark.getId(), chNo);
            if (Objects.nonNull(thirdTongchengParkChannel)){
                return ObjectResponse.success(thirdTongchengParkChannel);
            }
        }
        return ObjectResponse.failed(CodeConstantsEnum.ERROR_404);
    }
    @Override
    public ObjectResponse<ThirdTongchengParkChannel> selectTongchengParkCodeChannel(String parkCode, String channelCode) {
        ObjectResponse<ThirdTongchengPark> thirdTongchengParkObjectResponse = selectTongchengParkCode(parkCode);
        if (ObjectResponse.isSuccess(thirdTongchengParkObjectResponse)){
            ThirdTongchengPark tongchengPark = thirdTongchengParkObjectResponse.getData();
            ThirdTongchengParkChannel thirdTongchengParkChannel = tongchengParkChannelService.getThirdTongchengParkChannelByChannelCode(tongchengPark.getId(), channelCode);
            if (Objects.nonNull(thirdTongchengParkChannel)){
                return ObjectResponse.success(thirdTongchengParkChannel);
            }
        }
        return ObjectResponse.failed(CodeConstantsEnum.ERROR_404);
    }

    /**
     * 查询改接口是否是海大
     * @param parkId
     * @return
     */
    @Override
    public ThirdInfo selectHaiDaChuanXIng(Long parkId) {

        ThirdInfo thirdInfo = thirdParkDao.selectThirdByParkIdPID(parkId, "ACCESS_POWER");
        return thirdInfo;
    }

    @Override
    public ThirdInfo selectHaiDaJituan(Long parkId) {
        //根据推送地址查询海大的关联集团月卡的车场
        ThirdInfo thirdInfo = thirdParkDao.selectThirdByParkIdUrl(parkId, "HAIDA_MORECARD");
        return thirdInfo;
    }

    @Override
    public ObjectResponse<ThirdInfo> getThirdInfoBy(String pid, Long parkId) {
        ThirdInfo thirdInfo = thirdInfoDao.selectThirdInfoBy(pid, parkId);
        return thirdInfo == null ? ObjectResponse.failed(CodeConstantsEnum.ERROR_404) : ObjectResponse.success(thirdInfo);
    }
}
