package com.icetech.third.service.third;

import com.icetech.third.domain.entity.third.ThirdBstPark;
import com.icetech.db.mybatis.base.service.IBaseService;

/**
 * 泊斯特车场 服务类
 *
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wgy
 * @version 1.0 @date 2023-06-13
 */
public interface ThirdBstParkService extends IBaseService<ThirdBstPark> {

    /**
     * Description: 根据ID查询 泊斯特车场对象信息 <br>
     * Version1.0 2023-06-13 by wgy创建
     *
     * @param id 对象id
     * @return ThirdBstPark
     */
    ThirdBstPark getThirdBstParkById (Long id);

    /**
     * Description: 新增  泊斯特车场对象信息 <br>
     * Version1.0 2023-06-13 by wgy创建
     *
     * @param entity 对象信息
     * @return Boolean 返回新增后主键
     */
    Boolean addThirdBstPark (ThirdBstPark entity);

    /**
     * Description: 修改 泊斯特车场对象信息 <br>
     * Version1.0 2023-06-13 by wgy创建
     *
     * @param entity 对象信息
     * @return Boolean 返回更新后的结果
     */
    Boolean modifyThirdBstPark (ThirdBstPark entity);

    /**
     * Description: 删除  泊斯特车场对象信息 <br>
     * Version1.0 2023-06-13 by wgy创建
     *
     * @param id 对象id
     * @return Boolean 返回更新后的结果
     */
    Boolean removeThirdBstParkById (Long id);
}
