package com.icetech.third.service.third;

import com.fasterxml.jackson.core.type.TypeReference;
import com.icetech.basics.constants.TextConstant;
import com.icetech.basics.domain.entity.park.ParkConfig;
import com.icetech.cloudcenter.api.park.ParkService;
import com.icetech.cloudcenter.api.third.SendInfoService;
import com.icetech.cloudcenter.domain.request.NotifyRequest;
import com.icetech.common.constants.CodeConstantsEnum;
import com.icetech.common.constants.DataCollectionEnum;
import com.icetech.common.constants.ServiceEnum;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.thread.ThreadUtils;
import com.icetech.db.mybatis.base.service.impl.BaseServiceImpl;
import com.icetech.third.dao.send.SendinfoDao;
import com.icetech.third.dao.third.PushRecordDao;
import com.icetech.basics.domain.SendMessage;
import com.icetech.third.domain.entity.third.PushRecord;
import com.icetech.third.domain.entity.third.SendInfo;
import com.icetech.third.utils.JsonUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ThreadPoolExecutor;


/**
 * dubbo 接口 暴露 实现类
 * @author wangzw
 */
@Service("sendInfoService")
@Slf4j
public class SendInfoServiceImpl extends BaseServiceImpl<SendinfoDao, SendInfo> implements SendInfoService {
    @Autowired
    private SendinfoDao sendinfoDao;
    @Autowired
    private PushRecordDao pushRecordDao;
    @Autowired
    private ParkService parkService;
    @Autowired
    private ThreadPoolExecutor asyncExecutor;
    

    @Override
    public ObjectResponse notifySuccess(Integer serviceType, Integer serviceId) {
        return notifySuccess(serviceType, serviceId, ServiceEnum.Data.getType());
    }

    @Transactional
    @Override
    public ObjectResponse notify(NotifyRequest notifyRequest) {
        log.info("<回调异步通知> 成功，参数：{}", notifyRequest);
        SendInfo iceSendinfo;
        PushRecord pushRecord;
        ObjectResponse objectResponse = ObjectResponse.success();
        if (notifyRequest.getTaskId() != null) {
            iceSendinfo = sendinfoDao.selectById(notifyRequest.getTaskId().intValue());
            notifyRequest.setServiceId(iceSendinfo.getServiceId());
        } else {
            iceSendinfo = sendinfoDao.selectByServiceId(notifyRequest.getServiceType(), notifyRequest.getServiceId().intValue(), notifyRequest.getTargetService());
        }
        if (Objects.nonNull(iceSendinfo)) {
            iceSendinfo.setRetTime(new Date());
            String remark = iceSendinfo.getRemark();
            String one = notifyRequest.getOne();
            boolean success = notifyRequest.isSuccess();
            SendMessage sendMessage;
            if (success) {
                sendMessage = new SendMessage();
                iceSendinfo.setStatus(SendInfo.StatusEnum._SUCCESS.getCode());
                ObjectResponse<ParkConfig> parkConfigObject = parkService.getParkConfig(iceSendinfo.getParkId());
                ParkConfig parkConfig = parkConfigObject.getData();
                sendMessage.setType(parkConfig.getDataCollection().toString());
                iceSendinfo.setRemark(JsonUtils.toJson(sendMessage));
            } else {
                sendMessage = new SendMessage();
                iceSendinfo.setStatus(SendInfo.StatusEnum._FAIL.getCode());
                String cause = notifyRequest.getCause();
                // 错误原因处理
                if (StringUtils.isNotEmpty(cause)) {
                    if (StringUtils.isEmpty(remark)) {
                        ObjectResponse<ParkConfig> parkConfigObject = parkService.getParkConfig(iceSendinfo.getParkId());
                        ParkConfig parkConfig = parkConfigObject.getData();
                        sendMessage.setType(parkConfig.getDataCollection().toString());
                    } else {
                        try {
                            sendMessage = JsonUtils.fromJson(remark, new TypeReference<SendMessage>() {
                            });
                        } catch (Exception e) {
                            ObjectResponse<ParkConfig> parkConfigObject = parkService.getParkConfig(iceSendinfo.getParkId());
                            ParkConfig parkConfig = parkConfigObject.getData();
                            sendMessage.setType(parkConfig.getDataCollection().toString());
                        }
                    }
                    // 相机空间不足
                    if (cause.contains("over the limit") || cause.contains("data overlimit")) {
                        if (CollectionUtils.isEmpty(sendMessage.getDescribes())) {
                            sendMessage.setDescribes(Collections.singletonList(SendMessage.Describe.builder()
                                    .failType(TextConstant.CAMERA_INSUFFICIENT_SPACE)
                                    .serialNumbers(Collections.singletonList(one))
                                    .build()));
                        } else {
                            sendMessage.getDescribes().stream()
                                    .filter(Objects::nonNull)
                                    .filter(d -> TextConstant.CAMERA_INSUFFICIENT_SPACE.equals(d.getFailType()))
                                    .forEach(describe -> {
                                        List<String> serialNumbers = describe.getSerialNumbers();
                                        if (!serialNumbers.contains(one)) {
                                            serialNumbers.add(one);
                                        }
                                    });
                        }
                        //参数无效
                    } else if (cause.contains("Invalid parameter")) {
                        if (CollectionUtils.isEmpty(sendMessage.getDescribes())) {
                            sendMessage.setDescribes(Collections.singletonList(SendMessage.Describe.builder()
                                    .failType(TextConstant.INVALID_PARAM)
                                    .serialNumbers(Collections.singletonList(one))
                                    .build()));
                        } else {
                            sendMessage.getDescribes().stream()
                                    .filter(Objects::nonNull)
                                    .filter(d -> TextConstant.INVALID_PARAM.equals(d.getFailType()))
                                    .forEach(describe -> {
                                        List<String> serialNumbers = describe.getSerialNumbers();
                                        if (!serialNumbers.contains(one)) {
                                            serialNumbers.add(one);
                                        }
                                    });
                        }
                    } else {
                        // 其他情况
                        if (CollectionUtils.isEmpty(sendMessage.getDescribes())) {
                            if (StringUtils.isEmpty(one)) {
                                sendMessage.setDescribes(Collections.singletonList(SendMessage.Describe.builder()
                                        .failType(TextConstant.DEFAULT)
                                        .fixedDisplay(cause)
                                        .build()));
                            } else {
                                sendMessage.setDescribes(Collections.singletonList(SendMessage.Describe.builder()
                                        .failType(TextConstant.CAMERA_ERROR)
                                        .serialNumbers(Collections.singletonList(one))
                                        .fixedDisplay(cause)
                                        .build()));
                            }
                        } else {
                            if (StringUtils.isEmpty(one)) {
                                sendMessage.getDescribes().stream()
                                        .filter(Objects::nonNull)
                                        .filter(d -> TextConstant.DEFAULT.equals(d.getFailType()))
                                        .forEach(describe -> {
                                            List<String> serialNumbers = describe.getSerialNumbers();
                                            if (!serialNumbers.contains(one)) {
                                                serialNumbers.add(one);
                                            }
                                        });
                            } else {
                                sendMessage.getDescribes().stream()
                                        .filter(Objects::nonNull)
                                        .filter(d -> TextConstant.CAMERA_ERROR.equals(d.getFailType()))
                                        .forEach(describe -> {
                                            List<String> serialNumbers = describe.getSerialNumbers();
                                            if (!serialNumbers.contains(one)) {
                                                serialNumbers.add(one);
                                            }
                                        });
                            }
                        }
                    }
                }
                iceSendinfo.setRemark(JsonUtils.toJson(sendMessage));
            }
            sendinfoDao.updateById(iceSendinfo);

        } else {
            objectResponse = ObjectResponse.failed();
        }
        if (notifyRequest.getRecordId() != null) {
            pushRecord = pushRecordDao.selectById(notifyRequest.getRecordId());
            if (Objects.nonNull(pushRecord)) {
                String remark = pushRecord.getRemark();
                String one = notifyRequest.getOne();
                boolean success = notifyRequest.isSuccess();
                if (success) {
                    pushRecord.setPushResult(1);
                } else {
                    pushRecord.setPushResult(-1);
                    iceSendinfo.setStatus(SendInfo.StatusEnum._FAIL.getCode());
                    String cause = notifyRequest.getCause();
                    if (cause != null && (cause.contains("over the limit") || cause.contains("data overlimit"))) {
                        pushRecord.setPushCount(10);
                        cause = "相机空间不足";
                    }
                    pushRecord.setRemark((remark == null ? "" : remark + "; ") + one + "处理失败，原因：" + cause + ";");
                }
                pushRecordDao.updateById(pushRecord);
            }
        }
        return objectResponse;
    }

    @Override
    public ObjectResponse notifySuccess(Integer serviceType, Integer serviceId, Integer targetService) {
        asyncExecutor.execute(ThreadUtils.wrapTrace(() -> {
            SendInfo iceSendinfo = sendinfoDao.selectByServiceId(serviceType, serviceId, targetService);
            if (Objects.nonNull(iceSendinfo)) {
                //更新为成功状态
                iceSendinfo.setStatus(SendInfo.StatusEnum._SUCCESS.getCode());
                iceSendinfo.setRetTime(new Date());
                ObjectResponse<ParkConfig> parkConfigObject = parkService.getParkConfig(iceSendinfo.getParkId());
                ParkConfig parkConfig = parkConfigObject.getData();
                SendMessage sendMessage = new SendMessage();
                sendMessage.setType(parkConfig.getDataCollection().toString());
                iceSendinfo.setRemark(JsonUtils.toJson(sendMessage));
                sendinfoDao.updateById(iceSendinfo);
                log.info("<回调异步通知> 成功，参数：{}", iceSendinfo);
            }
        }));
        return ObjectResponse.success();
    }

    @Override
    public ObjectResponse notifyFail(Integer serviceType, Integer serviceId, Integer targetService, String cause) {
        asyncExecutor.execute(ThreadUtils.wrapTrace(() -> {
            SendInfo iceSendinfo = sendinfoDao.selectByServiceId(serviceType, serviceId, targetService);
            if (Objects.nonNull(iceSendinfo)) {
                //更新为成功状态
                iceSendinfo.setStatus(SendInfo.StatusEnum._FAIL.getCode());
                iceSendinfo.setRetTime(new Date());
                iceSendinfo.setRemark(cause);
                if ("prepay data over the limit".equals(cause)) {
                    iceSendinfo.setSendNum(10);
                }
                if (StringUtils.isNotEmpty(cause)) {
                    iceSendinfo.setRemark(JsonUtils.toJson(SendMessage.builder()
                            .type(TextConstant.TWO)
                            .describes(Collections.singletonList(SendMessage.Describe.builder()
                                    .failType(TextConstant.DEFAULT)
                                    .fixedDisplay(cause)
                                    .build()))
                            .build()));
                }
                sendinfoDao.updateById(iceSendinfo);
                log.info("<回调异步通知> 失败，参数：{}", iceSendinfo);
            }
        }));
        return ObjectResponse.success();
    }

    /**
     * 新增
     */
    @Override
    public ObjectResponse<String> insert(SendInfo iceSendinfo) {

        // valid
        if (iceSendinfo == null) {
            return ObjectResponse.failed(CodeConstantsEnum.ERROR_402);
        }

        sendinfoDao.insert(iceSendinfo);
        return ObjectResponse.success();
    }

    /**
     * 删除
     */
    @Override
    public ObjectResponse<String> delete(Long id) {
        int ret = sendinfoDao.deleteById(id);
        return ObjectResponse.success();
    }

    /**
     * 更新
     */
    @Override
    public ObjectResponse<String> update(SendInfo iceSendinfo) {
        int ret = sendinfoDao.updateById(iceSendinfo);
        return ObjectResponse.success();
    }
    /**
     * Load查询
     */
    @Override
    public SendInfo load(int id) {
        return sendinfoDao.selectById(id);
    }

    /**
     * 根据下发类型获取下发信息
     * @param sendType
     * @return
     */
    @Override
    public List<SendInfo> selectBySendTypeAndNum(int sendType, int maxNum) {
        return sendinfoDao.selectBySendTypeAndNum(sendType,maxNum);
    }
    /**
     * 根据状态获取下发信息
     * @param statusStr
     * @param maxNum
     * @return
     */
    @Override
    public List<SendInfo> selectByStatusAndNum(String statusStr,int maxNum) {
        return sendinfoDao.selectByStatusAndNum(statusStr,maxNum);
    }

    @Override
    public List<SendInfo> selectDownSendList(String statusStr, int minNum, int maxNum) {
        return sendinfoDao.selectByStatusAndNum2(statusStr, minNum, maxNum);
    }

    /**
     * 根据状态获取下发信息
     * @param statusStr
     * @param maxNum
     * @return
     */
    @Override
    public List<SendInfo> selectDownSendList(String statusStr, int maxNum){
        return sendinfoDao.selectDownSendList(statusStr,maxNum);
    }

    @Override
    public List<SendInfo> selectPushList(String statusStr, int maxNum) {
        return sendinfoDao.selectPushList(statusStr,maxNum);
    }

    @Override
    public int batchUpdate(List<SendInfo> collect) {
        super.updateBatchById(collect);
        return collect.size();
    }

    @Override
    public Boolean batchInsert(List<SendInfo> sendInfos) {
        return saveBatch(sendInfos);
    }

    @Override
    public int batchInsertHistory(List<SendInfo> iceSendinfos) {
        return sendinfoDao.batchInsertHistory(iceSendinfos);
    }

    @Override
    public int insertHistory(SendInfo iceSendinfo) {
        return sendinfoDao.insertHistory(iceSendinfo);
    }

    @Override
    public int batchDelete(List<Long> ids) {
        super.removeByIds(ids);
        return ids.size();
    }

    @Override
    public int updateSuccessByServiceIds(List<Long> ids, Integer serviceType) {
        return sendinfoDao.updateSuccessByServiceIds(ids, serviceType, null);
    }

    @Override
    public int updateSuccessByServiceIds(List<Long> ids, Integer serviceType, String remark) {
        return sendinfoDao.updateSuccessByServiceIds(ids, serviceType, remark);
    }

    @Override
    public int updateFailByServiceIds(List<Long> ids, Integer serviceType, String remark) {
        return sendinfoDao.updateFailByServiceIds(ids, serviceType, remark);
    }

    @Override
    public List<Long> selectFailListByIds(List<Long> ids) {
        return sendinfoDao.selectFailListByIds(ids);
    }

    @Override
    public int updateFailByIds(List<Long> ids, Integer status, String remark) {
        return sendinfoDao.updateFailByIds(ids, status, remark);
    }
}
