package com.icetech.third.service.third;

import java.util.Date;

import javax.annotation.Resource;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.icetech.cloudcenter.api.third.PushRecordService;
import com.icetech.third.dao.third.PushRecordDao;
import com.icetech.third.domain.entity.third.PushRecord;
import com.icetech.common.constants.CodeConstants;
import com.icetech.common.domain.response.ObjectResponse;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Slf4j
@Service("pushRecordService")
public class PushRecordServiceImpl extends ServiceImpl<PushRecordDao, PushRecord> implements PushRecordService {
    @Resource
    private PushRecordDao pushRecordDao;

    @Override
    public ObjectResponse<PushRecord> getRecordByMsg(String msgId, String group) {
        PushRecord record = pushRecordDao.selectLimitOne(
                Wrappers.lambdaQuery(PushRecord.class)
                        .eq(PushRecord::getMsgId, msgId)
                        .eq(PushRecord::getPushGroup, group));
        return ObjectResponse.returnNotFoundIfNull(record);
    }

    @Override
    public ObjectResponse<PushRecord> addRecord(PushRecord pushRecord) {
        if (StringUtils.length(pushRecord.getRemark()) > 200) {
            pushRecord.setRemark(pushRecord.getRemark().substring(0, 200));
        }
        int result = pushRecordDao.insert(pushRecord);
        return result == 1 ? ObjectResponse.success(pushRecord) : ObjectResponse.failed(CodeConstants.ERROR);
    }

    @Override
    public ObjectResponse<Integer> insertRecord(PushRecord pushRecord) {
        int result = pushRecordDao.insert(pushRecord);
        if (StringUtils.length(pushRecord.getRemark()) > 200) {
            pushRecord.setRemark(pushRecord.getRemark().substring(0, 200));
        }
        return ObjectResponse.success(result);
    }

    @Override
    public ObjectResponse<Integer> updateRecordById(PushRecord pushRecord) {
        pushRecord.setUpdateTime(new Date());
        int result = pushRecordDao.updateById(pushRecord);
        if (StringUtils.length(pushRecord.getRemark()) > 200) {
            pushRecord.setRemark(pushRecord.getRemark().substring(0, 200));
        }
        return ObjectResponse.success(result);
    }

    @Override
    public ObjectResponse<Integer> addOrUpdateById(PushRecord pushRecord) {
        if (StringUtils.length(pushRecord.getRemark()) > 200) {
            pushRecord.setRemark(pushRecord.getRemark().substring(0, 200));
        }
        int result = 0;
        if (pushRecord.getId() == null) {
            result = pushRecordDao.insert(pushRecord);
        } else {
            pushRecord.setUpdateTime(new Date());
            result = pushRecordDao.updateById(pushRecord);
        }
        return ObjectResponse.success(result);
    }

    @Override
    public ObjectResponse<Integer> deleteById(long id) {
        int result = pushRecordDao.deleteById(id);
        return ObjectResponse.success(result);
    }
}