package com.icetech.third.config.prop;

import java.util.HashSet;
import java.util.Set;

import lombok.Getter;
import lombok.Setter;
import lombok.ToString;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

@Getter
@Setter
@ToString
@Component
@ConfigurationProperties("ice.dtn.push")
public class DtnPushProp {
    protected boolean enabled = false;
    protected Set<Long> includeParkIds = new HashSet<>();

    public boolean isPush(Long parkId) {
        return enabled && parkId != null && includeParkIds.contains(parkId);
    }
}
