/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.third.service.third;

import com.fasterxml.jackson.core.type.TypeReference;
import com.icetech.basics.domain.SendMessage;
import com.icetech.basics.domain.entity.park.ParkConfig;
import com.icetech.cloudcenter.api.park.ParkService;
import com.icetech.cloudcenter.api.third.SendInfoService;
import com.icetech.cloudcenter.domain.request.NotifyRequest;
import com.icetech.common.constants.CodeConstantsEnum;
import com.icetech.common.constants.ServiceEnum;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.thread.ThreadUtils;
import com.icetech.db.mybatis.base.service.impl.BaseServiceImpl;
import com.icetech.third.dao.send.SendinfoDao;
import com.icetech.third.dao.third.PushRecordDao;
import com.icetech.third.domain.entity.third.PushRecord;
import com.icetech.third.domain.entity.third.SendInfo;
import com.icetech.third.utils.JsonUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="sendInfoService")
public class SendInfoServiceImpl
extends BaseServiceImpl<SendinfoDao, SendInfo>
implements SendInfoService {
    private static final Logger log = LoggerFactory.getLogger(SendInfoServiceImpl.class);
    @Autowired
    private SendinfoDao sendinfoDao;
    @Autowired
    private PushRecordDao pushRecordDao;
    @Autowired
    private ParkService parkService;
    @Autowired
    private ThreadPoolExecutor asyncExecutor;

    public ObjectResponse notifySuccess(Integer serviceType, Integer serviceId) {
        return this.notifySuccess(serviceType, serviceId, ServiceEnum.Data.getType());
    }

    @Transactional
    public ObjectResponse notify(NotifyRequest notifyRequest) {
        PushRecord pushRecord;
        boolean success;
        String one;
        String remark;
        SendInfo iceSendinfo;
        log.info("<\u56de\u8c03\u5f02\u6b65\u901a\u77e5> \u6210\u529f\uff0c\u53c2\u6570\uff1a{}", (Object)notifyRequest);
        ObjectResponse objectResponse = ObjectResponse.success();
        if (notifyRequest.getTaskId() != null) {
            iceSendinfo = (SendInfo)this.sendinfoDao.selectById(Integer.valueOf(notifyRequest.getTaskId().intValue()));
            notifyRequest.setServiceId(iceSendinfo.getServiceId());
        } else {
            iceSendinfo = this.sendinfoDao.selectByServiceId(notifyRequest.getServiceType(), notifyRequest.getServiceId().intValue(), notifyRequest.getTargetService());
        }
        if (Objects.nonNull(iceSendinfo)) {
            SendMessage sendMessage;
            iceSendinfo.setRetTime(new Date());
            remark = iceSendinfo.getRemark();
            one = notifyRequest.getOne();
            success = notifyRequest.isSuccess();
            if (success) {
                sendMessage = new SendMessage();
                iceSendinfo.setStatus(Integer.valueOf(SendInfo.StatusEnum._SUCCESS.getCode()));
                ObjectResponse parkConfigObject = this.parkService.getParkConfig(iceSendinfo.getParkId());
                ParkConfig parkConfig = (ParkConfig)parkConfigObject.getData();
                sendMessage.setType(parkConfig.getDataCollection().toString());
                iceSendinfo.setRemark(JsonUtils.toJson(sendMessage));
            } else {
                sendMessage = new SendMessage();
                iceSendinfo.setStatus(Integer.valueOf(SendInfo.StatusEnum._FAIL.getCode()));
                String cause = notifyRequest.getCause();
                if (StringUtils.isNotEmpty((CharSequence)cause)) {
                    if (StringUtils.isEmpty((CharSequence)remark)) {
                        ObjectResponse parkConfigObject = this.parkService.getParkConfig(iceSendinfo.getParkId());
                        ParkConfig parkConfig = (ParkConfig)parkConfigObject.getData();
                        sendMessage.setType(parkConfig.getDataCollection().toString());
                    } else {
                        try {
                            sendMessage = JsonUtils.fromJson(remark, new TypeReference<SendMessage>(){});
                        }
                        catch (Exception e) {
                            ObjectResponse parkConfigObject = this.parkService.getParkConfig(iceSendinfo.getParkId());
                            ParkConfig parkConfig = (ParkConfig)parkConfigObject.getData();
                            sendMessage.setType(parkConfig.getDataCollection().toString());
                        }
                    }
                    if (cause.contains("over the limit") || cause.contains("data overlimit")) {
                        if (CollectionUtils.isEmpty((Collection)sendMessage.getDescribes())) {
                            sendMessage.setDescribes(Collections.singletonList(SendMessage.Describe.builder().failType("10007").serialNumbers(Collections.singletonList(one)).build()));
                        } else {
                            sendMessage.getDescribes().stream().filter(Objects::nonNull).filter(d -> "10007".equals(d.getFailType())).forEach(describe -> {
                                List serialNumbers = describe.getSerialNumbers();
                                if (!serialNumbers.contains(one)) {
                                    serialNumbers.add(one);
                                }
                            });
                        }
                    } else if (cause.contains("Invalid parameter")) {
                        if (CollectionUtils.isEmpty((Collection)sendMessage.getDescribes())) {
                            sendMessage.setDescribes(Collections.singletonList(SendMessage.Describe.builder().failType("10008").serialNumbers(Collections.singletonList(one)).build()));
                        } else {
                            sendMessage.getDescribes().stream().filter(Objects::nonNull).filter(d -> "10008".equals(d.getFailType())).forEach(describe -> {
                                List serialNumbers = describe.getSerialNumbers();
                                if (!serialNumbers.contains(one)) {
                                    serialNumbers.add(one);
                                }
                            });
                        }
                    } else if (CollectionUtils.isEmpty((Collection)sendMessage.getDescribes())) {
                        if (StringUtils.isEmpty((CharSequence)one)) {
                            sendMessage.setDescribes(Collections.singletonList(SendMessage.Describe.builder().failType("10000").fixedDisplay(cause).build()));
                        } else {
                            sendMessage.setDescribes(Collections.singletonList(SendMessage.Describe.builder().failType("10009").serialNumbers(Collections.singletonList(one)).fixedDisplay(cause).build()));
                        }
                    } else if (StringUtils.isEmpty((CharSequence)one)) {
                        sendMessage.getDescribes().stream().filter(Objects::nonNull).filter(d -> "10000".equals(d.getFailType())).forEach(describe -> {
                            List serialNumbers = describe.getSerialNumbers();
                            if (!serialNumbers.contains(one)) {
                                serialNumbers.add(one);
                            }
                        });
                    } else {
                        sendMessage.getDescribes().stream().filter(Objects::nonNull).filter(d -> "10009".equals(d.getFailType())).forEach(describe -> {
                            List serialNumbers = describe.getSerialNumbers();
                            if (!serialNumbers.contains(one)) {
                                serialNumbers.add(one);
                            }
                        });
                    }
                }
                iceSendinfo.setRemark(JsonUtils.toJson(sendMessage));
            }
            this.sendinfoDao.updateById(iceSendinfo);
        } else {
            objectResponse = ObjectResponse.failed();
        }
        if (notifyRequest.getRecordId() != null && Objects.nonNull(pushRecord = (PushRecord)this.pushRecordDao.selectById(notifyRequest.getRecordId()))) {
            remark = pushRecord.getRemark();
            one = notifyRequest.getOne();
            success = notifyRequest.isSuccess();
            if (success) {
                pushRecord.setPushResult(Integer.valueOf(1));
            } else {
                pushRecord.setPushResult(Integer.valueOf(-1));
                iceSendinfo.setStatus(Integer.valueOf(SendInfo.StatusEnum._FAIL.getCode()));
                String cause = notifyRequest.getCause();
                if (cause != null && (cause.contains("over the limit") || cause.contains("data overlimit"))) {
                    pushRecord.setPushCount(Integer.valueOf(10));
                    cause = "\u76f8\u673a\u7a7a\u95f4\u4e0d\u8db3";
                }
                pushRecord.setRemark((remark == null ? "" : remark + "; ") + one + "\u5904\u7406\u5931\u8d25\uff0c\u539f\u56e0\uff1a" + cause + ";");
            }
            this.pushRecordDao.updateById(pushRecord);
        }
        return objectResponse;
    }

    public ObjectResponse notifySuccess(Integer serviceType, Integer serviceId, Integer targetService) {
        this.asyncExecutor.execute(ThreadUtils.wrapTrace(() -> {
            SendInfo iceSendinfo = this.sendinfoDao.selectByServiceId(serviceType, serviceId, targetService);
            if (Objects.nonNull(iceSendinfo)) {
                iceSendinfo.setStatus(Integer.valueOf(SendInfo.StatusEnum._SUCCESS.getCode()));
                iceSendinfo.setRetTime(new Date());
                ObjectResponse parkConfigObject = this.parkService.getParkConfig(iceSendinfo.getParkId());
                ParkConfig parkConfig = (ParkConfig)parkConfigObject.getData();
                SendMessage sendMessage = new SendMessage();
                sendMessage.setType(parkConfig.getDataCollection().toString());
                iceSendinfo.setRemark(JsonUtils.toJson(sendMessage));
                this.sendinfoDao.updateById(iceSendinfo);
                log.info("<\u56de\u8c03\u5f02\u6b65\u901a\u77e5> \u6210\u529f\uff0c\u53c2\u6570\uff1a{}", (Object)iceSendinfo);
            }
        }));
        return ObjectResponse.success();
    }

    public ObjectResponse notifyFail(Integer serviceType, Integer serviceId, Integer targetService, String cause) {
        this.asyncExecutor.execute(ThreadUtils.wrapTrace(() -> {
            SendInfo iceSendinfo = this.sendinfoDao.selectByServiceId(serviceType, serviceId, targetService);
            if (Objects.nonNull(iceSendinfo)) {
                iceSendinfo.setStatus(Integer.valueOf(SendInfo.StatusEnum._FAIL.getCode()));
                iceSendinfo.setRetTime(new Date());
                iceSendinfo.setRemark(cause);
                if ("prepay data over the limit".equals(cause)) {
                    iceSendinfo.setSendNum(Integer.valueOf(10));
                }
                if (StringUtils.isNotEmpty((CharSequence)cause)) {
                    iceSendinfo.setRemark(JsonUtils.toJson(SendMessage.builder().type("2").describes(Collections.singletonList(SendMessage.Describe.builder().failType("10000").fixedDisplay(cause).build())).build()));
                }
                this.sendinfoDao.updateById(iceSendinfo);
                log.info("<\u56de\u8c03\u5f02\u6b65\u901a\u77e5> \u5931\u8d25\uff0c\u53c2\u6570\uff1a{}", (Object)iceSendinfo);
            }
        }));
        return ObjectResponse.success();
    }

    public ObjectResponse<String> insert(SendInfo iceSendinfo) {
        if (iceSendinfo == null) {
            return ObjectResponse.failed((CodeConstantsEnum)CodeConstantsEnum.ERROR_402);
        }
        this.sendinfoDao.insert(iceSendinfo);
        return ObjectResponse.success();
    }

    public ObjectResponse<String> delete(Long id) {
        int ret = this.sendinfoDao.deleteById(id);
        return ObjectResponse.success();
    }

    public ObjectResponse<String> update(SendInfo iceSendinfo) {
        int ret = this.sendinfoDao.updateById(iceSendinfo);
        return ObjectResponse.success();
    }

    public SendInfo load(int id) {
        return (SendInfo)this.sendinfoDao.selectById(Integer.valueOf(id));
    }

    public List<SendInfo> selectBySendTypeAndNum(int sendType, int maxNum) {
        return this.sendinfoDao.selectBySendTypeAndNum(sendType, maxNum);
    }

    public List<SendInfo> selectByStatusAndNum(String statusStr, int maxNum) {
        return this.sendinfoDao.selectByStatusAndNum(statusStr, maxNum);
    }

    public List<SendInfo> selectDownSendList(String statusStr, int minNum, int maxNum) {
        return this.sendinfoDao.selectByStatusAndNum2(statusStr, minNum, maxNum);
    }

    public List<SendInfo> selectDownSendList(String statusStr, int maxNum) {
        return this.sendinfoDao.selectDownSendList(statusStr, maxNum);
    }

    public List<SendInfo> selectPushList(String statusStr, int maxNum) {
        return this.sendinfoDao.selectPushList(statusStr, maxNum);
    }

    public int batchUpdate(List<SendInfo> collect) {
        super.updateBatchById(collect);
        return collect.size();
    }

    public Boolean batchInsert(List<SendInfo> sendInfos) {
        return this.saveBatch(sendInfos);
    }

    public int batchInsertHistory(List<SendInfo> iceSendinfos) {
        return this.sendinfoDao.batchInsertHistory(iceSendinfos);
    }

    public int insertHistory(SendInfo iceSendinfo) {
        return this.sendinfoDao.insertHistory(iceSendinfo);
    }

    public int batchDelete(List<Long> ids) {
        super.removeByIds(ids);
        return ids.size();
    }

    public int updateSuccessByServiceIds(List<Long> ids, Integer serviceType) {
        return this.sendinfoDao.updateSuccessByServiceIds(ids, serviceType, null);
    }

    public int updateSuccessByServiceIds(List<Long> ids, Integer serviceType, String remark) {
        return this.sendinfoDao.updateSuccessByServiceIds(ids, serviceType, remark);
    }

    public int updateFailByServiceIds(List<Long> ids, Integer serviceType, String remark) {
        return this.sendinfoDao.updateFailByServiceIds(ids, serviceType, remark);
    }

    public List<Long> selectFailListByIds(List<Long> ids) {
        return this.sendinfoDao.selectFailListByIds(ids);
    }

    public int updateFailByIds(List<Long> ids, Integer status, String remark) {
        return this.sendinfoDao.updateFailByIds(ids, status, remark);
    }
}

