/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.third.service.third;

import cn.hutool.core.util.IdUtil;
import com.alibaba.fastjson.JSONObject;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.icetech.basics.domain.entity.device.HeartbeatOffline;
import com.icetech.basics.domain.entity.device.ParkDevice;
import com.icetech.basics.domain.entity.park.Opening;
import com.icetech.cloudcenter.api.park.ParkService;
import com.icetech.cloudcenter.api.third.ThirdParkService;
import com.icetech.cloudcenter.domain.request.p2c.HintRequest;
import com.icetech.cloudcenter.domain.request.p2c.LcdHintRequest;
import com.icetech.cloudcenter.domain.request.pnc.ShowAndSayRequest;
import com.icetech.common.domain.SendRequest;
import com.icetech.common.domain.mq.PushWrapper;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.domain.response.Response;
import com.icetech.common.utils.DateUtils;
import com.icetech.common.utils.UUIDTools;
import com.icetech.fee.domain.entity.monthcar.MonthInfo;
import com.icetech.fee.domain.entity.vip.VipInfo;
import com.icetech.mq.sender.RabbitSender;
import com.icetech.order.domain.entity.BarrierGateException;
import com.icetech.order.domain.entity.OrderBack;
import com.icetech.order.domain.entity.OrderInfo;
import com.icetech.order.domain.entity.OrderNotpay;
import com.icetech.order.domain.entity.OrderPay;
import com.icetech.order.domain.entity.OrderSonInfo;
import com.icetech.park.domain.entity.ChannelAlarm;
import com.icetech.park.domain.entity.ShamPlate;
import com.icetech.park.domain.entity.park.ExitIdentify;
import com.icetech.park.domain.entity.park.Park;
import com.icetech.third.anno.AsyncMethod;
import com.icetech.third.config.prop.DtnPushProp;
import com.icetech.third.dao.third.PushMessageDao;
import com.icetech.third.domain.entity.third.PushMessage;
import com.icetech.third.domain.enums.PushServiceEnum;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.core.MessageBuilder;
import org.springframework.amqp.core.MessageProperties;
import org.springframework.amqp.rabbit.connection.CorrelationData;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.concurrent.ListenableFutureCallback;

@Service
public class MqPushService {
    private static final Logger log = LoggerFactory.getLogger(MqPushService.class);
    @Resource
    private PushMessageDao pushMessageDao;
    @Resource
    private ThirdParkService thirdParkService;
    @Resource
    private RabbitTemplate rabbitTemplate;
    @Autowired
    private RabbitSender rabbitSender;
    @Autowired
    private DtnPushProp dtnPushProp;
    @Autowired
    private ParkService parkService;
    @Autowired
    private ObjectMapper objectMapper;
    public static final String ROUTING_KEY_EXIT_IDENTIFY = "order.exit.identify";

    @AsyncMethod
    public void pushExitIdentify(ExitIdentify exitIdentify) {
        this.pushMessage(exitIdentify.getParkId(), 16, UUIDTools.getUuid(), exitIdentify, ROUTING_KEY_EXIT_IDENTIFY, 1500);
    }

    @AsyncMethod
    public void pushOrderEnter(OrderInfo orderInfo) {
        this.pushMessage(orderInfo.getParkId(), 1, String.valueOf(orderInfo.getId()), orderInfo, "order.enter", 3000);
        this.pushEventMsgToCommon(orderInfo, 1);
    }

    @AsyncMethod
    public void pushOrderSonEnter(OrderSonInfo orderSonInfo) {
        this.pushMessage(orderSonInfo.getParkId(), 7, String.valueOf(orderSonInfo.getId()), orderSonInfo, "order.son.enter", 3000);
    }

    @AsyncMethod
    public void pushOrderExit(OrderInfo orderInfo) {
        this.pushOrderExit(orderInfo, 3000);
    }

    @AsyncMethod
    public void pushOrderExit(OrderInfo orderInfo, Integer delay) {
        this.pushMessage(orderInfo.getParkId(), 2, String.valueOf(orderInfo.getId()), orderInfo, "order.exit", delay);
        this.pushEventMsgToCommon(orderInfo, 2);
    }

    @AsyncMethod
    public void pushOrderSonExit(OrderSonInfo orderSonInfo) {
        this.pushMessage(orderSonInfo.getParkId(), 8, String.valueOf(orderSonInfo.getId()), orderSonInfo, "order.son.exit", 3000);
    }

    @AsyncMethod
    public void pushOrderPay(OrderPay orderPay) {
        this.pushMessage(orderPay.getParkId(), 3, String.valueOf(orderPay.getId()), orderPay, "order.pay", 3000);
    }

    @AsyncMethod
    public void pushOrderPaySync(OrderPay orderPay) {
        this.rabbitSender.sendMessage("notify.exchange", "notify.discount.routing", (Object)orderPay);
    }

    @AsyncMethod
    public void pushDeviceStatus(ParkDevice parkDevice) {
        if (this.dtnPushProp.isPush(parkDevice.getParkId()) || this.thirdParkService.checkPermissionService(parkDevice.getParkId().longValue(), PushServiceEnum.\u8bbe\u5907\u72b6\u6001\u53d8\u5316.getServiceName())) {
            this.pushMessage(parkDevice.getParkId(), 4, parkDevice.getId().toString(), parkDevice, "device.status.update", null);
        }
        if (Integer.valueOf(2).equals(parkDevice.getStatus())) {
            this.pushMessageNotPersistent(parkDevice.getParkId(), 11, parkDevice.getId().toString(), parkDevice, "device.offline", null);
        }
    }

    public void pushMonthNearExpired(MonthInfo monthInfo, Integer delayMillis) {
        this.pushMessageNotPersistent(monthInfo.getParkId(), 14, monthInfo.getId().toString(), monthInfo, "month.near.expired", delayMillis);
    }

    public void pushVipNearExpired(VipInfo vipInfo, Integer delayMillis) {
        this.pushMessageNotPersistent(vipInfo.getParkId().intValue(), 15, vipInfo.getId().toString(), vipInfo, "vip.near.expired", delayMillis);
    }

    public void pushPncCenterOffline(HeartbeatOffline offline) {
        this.pushMessageNotPersistent(offline.getParkId(), 12, offline.getId().toString(), offline, "pnc.center.offline", null);
    }

    public void pushPncChargeOffline(HeartbeatOffline offline) {
        this.pushMessageNotPersistent(offline.getParkId(), 13, offline.getId().toString(), offline, "pnc.charge.offline", null);
    }

    public void pushZsBusyHint(Long parkId, String sn, String messageId, int delay) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("parkId", parkId);
        param.put("sn", sn);
        param.put("messageId", messageId);
        this.pushMessageNotPersistent(parkId, 16, sn, param, "zs.busy.hint.routing", delay);
    }

    @AsyncMethod
    public void pushErrorOpen(Opening opening) {
        if (this.thirdParkService.checkPermissionService((long)opening.getParkId(), PushServiceEnum.\u5f00\u5173\u95f8\u62a5\u8b66.getServiceName())) {
            this.pushMessage(opening.getParkId(), 5, String.valueOf(opening.getId()), opening, "error.open", null);
        }
    }

    @AsyncMethod
    public void pushBatchDownSend(Long parkId, List<SendRequest> sendRequestList) {
        this.pushMessage(parkId, 6, String.valueOf(UUIDTools.getUuid()), sendRequestList, "batch.down.send.routing", 3000);
    }

    @AsyncMethod
    public void pushParkFreeSpace(Long parkId) {
        this.pushMessageNotPersistent(parkId, 9, String.valueOf(parkId), null, "park.free.space", 3000);
    }

    @AsyncMethod
    public void pushRegionFreeSpace(Long parkId, Long regionId) {
        this.pushMessageNotPersistent(parkId, 10, String.valueOf(regionId), null, "region.free.space", 3000);
    }

    public void pushOrderNotPay(OrderNotpay notpay) {
        if (this.dtnPushProp.isPush(notpay.getParkId())) {
            this.pushMessageNotPersistent(notpay.getParkId(), 20, String.valueOf(notpay.getId()), notpay, "order.not_pay", 3000);
        }
    }

    public void pushShamPlate(ShamPlate shamPlate) {
        if (this.dtnPushProp.isPush(shamPlate.getParkId())) {
            this.pushMessageNotPersistent(shamPlate.getParkId(), 21, String.valueOf(shamPlate.getId()), shamPlate, "order.sham_plate", 3000);
        }
    }

    public void pushOrderBack(OrderBack orderBack) {
        if (this.dtnPushProp.isPush(orderBack.getParkId())) {
            this.pushMessageNotPersistent(orderBack.getParkId(), 22, String.valueOf(orderBack.getId()), orderBack, "order.order_back", 3000);
        }
    }

    public void pushBarrierGateException(BarrierGateException exception) {
        if (this.dtnPushProp.isPush(exception.getParkId())) {
            this.pushMessageNotPersistent(exception.getParkId(), 23, String.valueOf(exception.getId()), exception, "gate.exception", 3000);
        }
    }

    public void pushChannelAlarm(ChannelAlarm channelAlarm) {
        if (this.dtnPushProp.isPush(channelAlarm.getParkId())) {
            this.pushMessageNotPersistent(channelAlarm.getParkId(), 24, String.valueOf(channelAlarm.getId()), channelAlarm, "channel.alarm", 3000);
        }
    }

    public void pushOrderEnexShow(final Long parkId, final String channelCode, final String deviceSn, final String show) {
        if (this.dtnPushProp.isPush(parkId)) {
            this.pushMessageNotPersistent(parkId, 30, channelCode, new JSONObject(){
                {
                    this.put("parkId", parkId);
                    this.put("channelCode", channelCode);
                    this.put("deviceSn", deviceSn);
                    this.put("show", show);
                }
            }, "order.enex.show", 3000);
        }
    }

    public void pushP2cLedScreen(Long parkId, String deviceSn, HintRequest request) {
        if (this.dtnPushProp.isPush(parkId)) {
            this.pushMessageNotPersistent(parkId, 31, deviceSn, request, "p2c.led_screen", 3000);
        }
    }

    public void pushP2cLcdScreen(Long parkId, String deviceSn, LcdHintRequest request) {
        if (this.dtnPushProp.isPush(parkId)) {
            this.pushMessageNotPersistent(parkId, 32, deviceSn, request, "p2c.lcd_screen", 3000);
        }
    }

    public void pushPncScreen(Long parkId, String channelCode, ShowAndSayRequest request) {
        if (this.dtnPushProp.isPush(parkId)) {
            this.pushMessageNotPersistent(parkId, 33, channelCode, request, "pnc.screen", 3000);
        }
    }

    private void pushMessage(long parkId, int pushType, String dataId, Object content, String routingKey, Integer delay) {
        PushWrapper wrapper = new PushWrapper();
        wrapper.setPushType(routingKey);
        wrapper.setParkId(Long.valueOf(parkId));
        wrapper.setDataId(dataId);
        wrapper.setContent(content);
        String body = JSONObject.toJSONString((Object)wrapper);
        String msgId = UUIDTools.getUuid();
        PushMessage record = new PushMessage();
        record.setMsgId(msgId);
        record.setParkId(Long.valueOf(parkId));
        record.setMsgType(Integer.valueOf(pushType));
        record.setDataId(dataId);
        record.setContent(body);
        record.setCreateTime(new Date());
        this.pushMessageDao.insert(record);
        final long recordId = record.getId();
        Message message = (Message)MessageBuilder.withBody((byte[])body.getBytes()).setMessageIdIfAbsent(msgId).setContentType("application/json").setHeader("count", (Object)1).setHeader("tag", (Object)routingKey).build();
        if (delay != null) {
            message.getMessageProperties().setDelay(delay);
        }
        CorrelationData correlationData = null;
        if ((this.rabbitTemplate.isUsePublisherConnection() && this.rabbitTemplate.getConnectionFactory().getPublisherConnectionFactory() != null ? this.rabbitTemplate.getConnectionFactory().getPublisherConnectionFactory() : this.rabbitTemplate.getConnectionFactory()).isPublisherConfirms()) {
            correlationData = new CorrelationData();
            correlationData.getFuture().addCallback((ListenableFutureCallback)new ListenableFutureCallback<CorrelationData.Confirm>(){

                public void onFailure(Throwable ex) {
                    PushMessage record = new PushMessage();
                    record.setId(Long.valueOf(recordId));
                    record.setPublishResult(Integer.valueOf(-1));
                    record.setRemark(ex.getMessage() == null ? "\u53d1\u9001\u7a0b\u5e8f\u51fa\u9519" : ex.getMessage().substring(0, 255));
                    MqPushService.this.pushMessageDao.updateById(record);
                }

                public void onSuccess(CorrelationData.Confirm result) {
                    PushMessage record = new PushMessage();
                    record.setId(Long.valueOf(recordId));
                    record.setPublishResult(Integer.valueOf(result.isAck() ? 1 : -1));
                    record.setRemark(result.getReason());
                    MqPushService.this.pushMessageDao.updateById(record);
                }
            });
        }
        this.rabbitTemplate.send("icecloud.event", routingKey, message, correlationData);
        log.info("MQ\u63a8\u9001\u5b8c\u6210[{}], parkId:{}, tag:{}, pushType:{}, dataId:{}", new Object[]{message.getMessageProperties().getMessageId(), parkId, routingKey, pushType, dataId});
    }

    private void pushMessageNotPersistent(final long parkId, final int pushType, final String dataId, Object content, final String routingKey, Integer delay) {
        PushWrapper wrapper = new PushWrapper();
        wrapper.setPushType(routingKey);
        wrapper.setParkId(Long.valueOf(parkId));
        wrapper.setDataId(dataId);
        wrapper.setContent(content);
        String body = JSONObject.toJSONString((Object)wrapper);
        String msgId = UUIDTools.getUuid();
        final Message message = (Message)MessageBuilder.withBody((byte[])body.getBytes()).setMessageIdIfAbsent(msgId).setContentType("application/json").setHeader("count", (Object)1).setHeader("tag", (Object)routingKey).build();
        if (delay != null) {
            message.getMessageProperties().setDelay(delay);
        }
        CorrelationData correlationData = null;
        if ((this.rabbitTemplate.isUsePublisherConnection() && this.rabbitTemplate.getConnectionFactory().getPublisherConnectionFactory() != null ? this.rabbitTemplate.getConnectionFactory().getPublisherConnectionFactory() : this.rabbitTemplate.getConnectionFactory()).isPublisherConfirms()) {
            correlationData = new CorrelationData();
            correlationData.getFuture().addCallback((ListenableFutureCallback)new ListenableFutureCallback<CorrelationData.Confirm>(){

                public void onFailure(Throwable ex) {
                    log.warn("MQ\u63a8\u9001\u5931\u8d25[{}], parkId:{}, tag:{}, pushType:{}, dataId:{}", new Object[]{message.getMessageProperties().getMessageId(), parkId, routingKey, pushType, dataId});
                }

                public void onSuccess(CorrelationData.Confirm result) {
                }
            });
        }
        this.rabbitTemplate.send("icecloud.event", routingKey, message, correlationData);
        log.info("MQ\u63a8\u9001\u5b8c\u6210[{}], parkId:{}, tag:{}, pushType:{}, dataId:{}", new Object[]{message.getMessageProperties().getMessageId(), parkId, routingKey, pushType, dataId});
    }

    private void pushEventMsgToCommon(OrderInfo orderInfo, int eventType) {
        try {
            ObjectResponse parkResp = this.parkService.findByParkId(orderInfo.getParkId());
            if (!ObjectResponse.isSuccess((Response)parkResp)) {
                log.info("\u83b7\u53d6\u8f66\u573a\u4fe1\u606f\u5931\u8d25\uff01\uff1a{}", (Object)parkResp);
                return;
            }
            Park park = (Park)parkResp.getData();
            if (Objects.isNull(park)) {
                log.info("\u672a\u83b7\u53d6\u5230\u8f66\u573a\u4fe1\u606f");
                return;
            }
            HashMap<String, Object> body = new HashMap<String, Object>(8);
            HashMap<String, Object> content = new HashMap<String, Object>(8);
            content.put("carStatus", eventType);
            content.put("plateNum", orderInfo.getPlateNum());
            if (eventType == 1) {
                content.put("statusDate", DateUtils.toLocalDateTimeOfSecond((long)orderInfo.getEnterTime()).format(DateUtils.DEFAULT_DATETIME_FORMAT));
            } else {
                content.put("statusDate", DateUtils.toLocalDateTimeOfSecond((long)orderInfo.getExitTime()).format(DateUtils.DEFAULT_DATETIME_FORMAT));
            }
            content.put("parkCode", park.getParkCode());
            body.put("messageId", IdUtil.fastSimpleUUID());
            body.put("serviceName", "specialMessage");
            body.put("timestamp", System.currentTimeMillis());
            body.put("bizContent", content);
            this.sendMessage("common.server.event", "common.server.event", this.objectMapper.writeValueAsString(body));
        }
        catch (Exception e) {
            log.error("\u4e1a\u52a1\u53d1\u751f\u5f02\u5e38\uff0c\u6d88\u606f\u63a8\u9001Mq\u5931\u8d25\uff1a", (Throwable)e);
        }
    }

    private void sendMessage(String exchange, String routingKey, String message, Long delayMillis) {
        Assert.hasText((String)exchange, (String)"\u4ea4\u6362\u673a\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)message, (String)"\u6d88\u606f\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a");
        String messageId = UUID.randomUUID().toString();
        try {
            MessageProperties properties = new MessageProperties();
            properties.setMessageId(messageId);
            properties.setContentEncoding(StandardCharsets.UTF_8.name());
            if (delayMillis != null && delayMillis > 0L) {
                properties.setHeader("x-delay", (Object)delayMillis);
                log.debug("\u51c6\u5907\u53d1\u9001\u5ef6\u8fdf\u6d88\u606f\uff0c\u6d88\u606fID: {}, \u5ef6\u8fdf\u65f6\u95f4: {}ms", (Object)messageId, (Object)delayMillis);
            }
            Message msg = new Message(message.getBytes(StandardCharsets.UTF_8), properties);
            this.rabbitTemplate.convertAndSend(exchange, routingKey, (Object)msg);
            log.info("\u6d88\u606f\u53d1\u9001\u6210\u529f\uff0c\u6d88\u606fID: {}, \u4ea4\u6362\u673a: {}, \u8def\u7531\u952e: {}", new Object[]{messageId, exchange, routingKey});
        }
        catch (Exception e) {
            log.error("\u6d88\u606f\u53d1\u9001\u5931\u8d25\uff0c\u4ea4\u6362\u673a: {}, \u8def\u7531\u952e: {}, \u9519\u8bef\u539f\u56e0: {}", new Object[]{exchange, routingKey, e.getMessage(), e});
        }
    }

    public void sendMessage(String exchange, String routingKey, String message) {
        log.debug("\u5f00\u59cb\u53d1\u9001\u666e\u901a\u6d88\u606f\uff0c\u4ea4\u6362\u673a: {}, \u8def\u7531\u952e: {}", (Object)exchange, (Object)routingKey);
        this.sendMessage(exchange, routingKey, message, null);
    }
}

