package com.icetech.third.utils;

import com.google.common.collect.Lists;
import com.icetech.common.utils.DateTools;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

/**
 * @author wangzw
 */
public class DateRangeUtils {

    /**
     * 获取当前天到现在的小时时间段
     * @return
     */
    public static List<Integer> getCurrentHours(){
        Date date = new Date();
        SimpleDateFormat sdf = new SimpleDateFormat("HH");
        String hour = sdf.format(date);
        Integer integer = Integer.valueOf(hour);
        List<Integer> hours = Lists.newArrayList();
        for (int i= 0;i<=integer-1;i++){
            hours.add(i);
        }
        return hours;
    }

    /**
     * 功能描述：返回小时
     *
     * @param date
     *            日期
     * @return 返回小时
     */
    public static int getHour(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar.get(Calendar.HOUR_OF_DAY);
    }

    /**
     * 获取当天已过去的小时
     * @return
     */
    public static List<Integer> getNowHours(){
        List<Integer> list = new ArrayList<>();
        List<Integer> hours = get24Hours();
        int nowhour = getHour(new Date());
        for (Integer integer:hours){
            if(integer < nowhour ){
                list.add(integer);
            }
        }
        return list;
    }
    /**
     * 获取整体所有小时
     * @return
     */
    public static List<Integer> get24DayHours(){
        List<Integer> res = Lists.newArrayList();
        for (int i = 0;i<24;i++){
            Integer integer = Integer.valueOf(i);
            res.add(integer);
        }
        return res;
    }
    /**
     * 获取前24 小时 的小时时间段 不包含当前所在的小时
     * @return
     */
    public static List<Integer> get24Hours(){
        List<Integer> res = Lists.newArrayList();
        SimpleDateFormat sdf = new SimpleDateFormat("HH");
        Date date = new Date();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(Calendar.DATE, -1);
        //添加第一个
        String firstHour = sdf.format(calendar.getTime());
        res.add(Integer.valueOf(firstHour));
        for (int i = 0;i<23;i++){
            calendar.add(Calendar.HOUR,1);
            Date time = calendar.getTime();
            String hour = sdf.format(time);
            Integer integer = Integer.valueOf(hour);
            res.add(integer);
        }
        return res;
    }

    /**
     * 获取前 n 天 的天数时间段 不包含当天
     * @return
     */
    public static List<String> getDays(Integer day){
        return getDaysMultiformat(day, 0);
    }
    /**
     * 获取前 n 天 的天数时间段 年月日
     * 0=MM/dd  1=yyyy-MM-dd
     * @return
     */
    public static List<String> getDaysMultiformat(Integer day,int type){
        SimpleDateFormat sdf = new SimpleDateFormat("MM/dd");
        if(type == 1){
            sdf = new SimpleDateFormat("yyyy/MM/dd");
        }
        List<String> res = Lists.newArrayList();
        Date date = new Date();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(Calendar.DATE, -day);
        String firstDay = sdf.format(calendar.getTime());
        res.add(firstDay);
        for (int i=0;i<day-1;i++){
            calendar.add(Calendar.DATE, 1);
            Date time = calendar.getTime();
            String format = sdf.format(time);
            res.add(format);
        }
        return res;
    }

    /**
     * 获取当前月前的所有月份
     * @return
     */
    public static List<String> getMonths(int nowyear){
        List<String> res = Lists.newArrayList();
        Calendar cal = Calendar.getInstance();
        int year = cal.get(Calendar.YEAR);
        int month = cal.get(Calendar.MONTH) + 1 ;
        if(year != nowyear){
            month = 12 ;
            year = nowyear;
        }
        for (int i = 1; i <= month; i++) {
            String str = year+"/";
            if((i+"").length()== 1){
                str = str + "0"+i;
            }else{
                str = str +i;
            }
            res.add(str);
        }
        return res;
    }
    /**
     * 获取今天凌晨0点的时间戳
     * @return
     */
    public static Long getTodayTime(){
        Calendar c = Calendar.getInstance();
        c.set(Calendar.HOUR_OF_DAY, 0);
        c.set(Calendar.MINUTE, 0);
        c.set(Calendar.SECOND, 0);
        c.set(Calendar.MILLISECOND, 0);
        return c.getTimeInMillis()/1000;
    }

    /**
     * 获取n天之前的时间戳
     * @param day
     * @return
     */
    public static Long getDayTime(Integer day) {
        Calendar c = Calendar.getInstance();
        c.set(Calendar.HOUR_OF_DAY, 0);
        c.set(Calendar.MINUTE, 0);
        c.set(Calendar.SECOND, 0);
        c.set(Calendar.MILLISECOND, 0);
        c.add(Calendar.DATE, -day);
        return c.getTimeInMillis()/1000;
    }


    /**
     * 获取n小时之前时间戳
     * @param integer
     * @return
     */
    public static Long getNHourTime(Integer integer) {
        Calendar c = Calendar.getInstance();
        c.setTimeInMillis(getNowHourTime()*1000);
        c.add(Calendar.HOUR, -integer);
        return c.getTimeInMillis()/1000;
    }

    /**
     * 获取昨天起始时间的时间戳
     * @return
     */
    public static Long getYesterdayHourTime(int pastHour) {
        Calendar c = Calendar.getInstance();
        c.setTimeInMillis(getNowHourTime()*1000);
        c.add(Calendar.HOUR, -pastHour);
        return c.getTimeInMillis()/1000;
    }
    /**
     * 获取24小时之前的时间戳
     * @return
     */
    public static Long get24HourTime() {
       Calendar c = Calendar.getInstance();
       c.setTimeInMillis(getNowHourTime()*1000);
       c.add(Calendar.HOUR, -24);
       return c.getTimeInMillis()/1000;
    }
    /**
     * 获取当前整点的时间戳
     * @return
     */
    public static long getNowHourTime() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:00:00");
        Date parse = null;
        try {
            parse = sdf.parse(sdf.format(new Date()));
        } catch (ParseException e) {
            throw new RuntimeException(e);
        }
        return parse.getTime()/1000;
    }
    /**
     * 获取当前出入时间的整点的时间戳
     * @return
     */
    public static long getTimeHourTime(String time) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:00:00");
        Date parse = null;
        try {
            parse = sdf.parse(time);
        } catch (ParseException e) {
            throw new RuntimeException(e);
        }
        return parse.getTime()/1000;
    }
    /**
     * 获取当前出入时间下一小时的时间戳
     * @return
     */
    public static Long getNextTimeHourTime(Long time,Integer hour) {
        Calendar c = Calendar.getInstance();
        c.setTimeInMillis(time*1000);
        c.add(Calendar.HOUR, hour);
        return c.getTimeInMillis()/1000;
    }
    public static int getDaysOfMonth(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar.getActualMaximum(Calendar.DAY_OF_MONTH);
    }

    /**
     * 获取某个月的所有天
     * @param month yyyy-mm
     * @throws Exception
     */
    public static List<String> getMonthDays(String month) throws Exception{
        SimpleDateFormat sdf1 = new SimpleDateFormat("yyyy-MM-dd");
        int day = getDaysOfMonth(sdf1.parse(month+"-01"));
        SimpleDateFormat sdf = new SimpleDateFormat("MM/dd");
        List<String> res = Lists.newArrayList();
        SimpleDateFormat sdfs = new SimpleDateFormat("yyyy-MM-dd");
        Date date = sdfs.parse(month+"-"+day);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(Calendar.DATE, -day);
        String firstDay = sdf.format(calendar.getTime());
        res.add(firstDay);
        for (int i=0;i<day;i++){
            calendar.add(Calendar.DATE, 1);
            Date time = calendar.getTime();
            String format = sdf.format(time);
            res.add(format);
        }
        return res;
    }



    /**
     * 获取参数日期到当前时间的季度列表
     * @param startDate 开始时间
     * @return 列表
     */
    public static List<String> getYearQuarterRangeTableName(Date startDate) {
        if (startDate == null) {
            startDate = new Date();
        }
        Date nowDate = new Date();
        List<String> list = new ArrayList<>();
        String quarter1 = getYearQuarter(nowDate);
        list.add(quarter1);
        String startQuarter = getYearQuarter(startDate);
        if (startQuarter.equals(quarter1)) {
            return list;
        }
        Calendar calendar = Calendar.getInstance();
        for (int i = 0; i < 4; i++) {
            calendar.add(Calendar.MONTH, -3);
            String yearQuarter = getYearQuarter(calendar.getTime());
            if (yearQuarter.equals(startQuarter)) {
                list.add(yearQuarter);
                break;
            }
            list.add(yearQuarter);
        }
        return list;
    }

    private static String getYearQuarter(Date startDate) {
        Calendar instance = Calendar.getInstance();
        instance.setTime(startDate);
        int paraYear = instance.get(Calendar.YEAR);
        int paraMonth = instance.get(Calendar.MONTH);
        int jidu = (paraMonth + 3) / 3;
        return paraYear + "q" + jidu;
    }

}
