package com.icetech.third.service.third;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.icetech.common.constants.SqlConstant;
import com.icetech.db.mybatis.base.service.impl.BaseServiceImpl;
import com.icetech.third.dao.third.ThirdTongchengParkMapper;
import com.icetech.third.domain.entity.third.ThirdTongchengPark;
import com.icetech.third.service.ThirdTongchengParkService;
import org.springframework.stereotype.Service;

/**
 * 同城支付第三方车场配置 服务实现类
 *
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wangzhiwei
 * @version 1.0 @date 2024-06-20
 */
@Service
public class ThirdTongchengParkServiceImpl extends BaseServiceImpl<ThirdTongchengParkMapper, ThirdTongchengPark> implements ThirdTongchengParkService {

    /**
     * Description: 根据ID查询 同城支付第三方车场配置对象信息 <br>
     * Version1.0 2024-06-20 by wangzhiwei创建
     *
     * @param id 对象id
     * @return ThirdTongchengPark
     */
    @Override
    public ThirdTongchengPark getThirdTongchengParkById (Long id) {
        return getById(id);
    }

    @Override
    public ThirdTongchengPark getThirdTongchengParkByThirdIdAndParkNo(String thirdParkNo) {
        return getOne(Wrappers.lambdaQuery(ThirdTongchengPark.class)
                .eq(ThirdTongchengPark::getThirdParkNo, thirdParkNo)
                .eq(ThirdTongchengPark::getState, 1)
                .last(SqlConstant.LIMIT_ONE));
    }
    @Override
    public ThirdTongchengPark getThirdTongchengParkByThirdIdAndParkCode(String parkCode) {
        return getOne(Wrappers.lambdaQuery(ThirdTongchengPark.class)
                .eq(ThirdTongchengPark::getParkCode, parkCode)
                .eq(ThirdTongchengPark::getState, 1)
                .last(SqlConstant.LIMIT_ONE));
    }

    /**
     * Description: 新增  同城支付第三方车场配置对象信息 <br>
     * Version1.0 2024-06-20 by wangzhiwei创建
     *
     * @param entity 对象信息
     * @return Boolean 返回新增后主键
     */
    @Override
    public Boolean addThirdTongchengPark (ThirdTongchengPark entity) {
        return save(entity);
    }

    /**
     * Description: 修改 同城支付第三方车场配置对象信息 <br>
     * Version1.0 2024-06-20 by wangzhiwei创建
     *
     * @param entity 对象信息
     * @return Boolean 返回更新后的结果
     */
    @Override
    public Boolean modifyThirdTongchengPark (ThirdTongchengPark entity) {
        return updateById(entity);
    }

    /**
     * Description: 删除  同城支付第三方车场配置对象信息 <br>
     * Version1.0 2024-06-20 by wangzhiwei创建
     *
     * @param id 对象id
     * @return Boolean 返回更新后的结果
     */
    @Override
    public Boolean removeThirdTongchengParkById (Long id) {
        return removeById(id);
    }

}
