package com.icetech.third.service.third;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.icetech.common.constants.SqlConstant;
import com.icetech.db.mybatis.base.service.impl.BaseServiceImpl;
import com.icetech.third.dao.third.ThirdTongchengParkChannelMapper;
import com.icetech.third.domain.entity.third.ThirdTongchengParkChannel;
import com.icetech.third.service.ThirdTongchengParkChannelService;
import org.springframework.stereotype.Service;

/**
 *  服务实现类
 *
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wangzhiwei
 * @version 1.0 @date 2024-06-20
 */
@Service
public class ThirdTongchengParkChannelServiceImpl extends BaseServiceImpl<ThirdTongchengParkChannelMapper, ThirdTongchengParkChannel> implements ThirdTongchengParkChannelService {

    /**
     * Description: 根据ID查询 对象信息 <br>
     * Version1.0 2024-06-20 by wangzhiwei创建
     *
     * @param id 对象id
     * @return ThirdTongchengParkChannel
     */
    @Override
    public ThirdTongchengParkChannel getThirdTongchengParkChannelById (Long id) {
        return getById(id);
    }

    @Override
    public ThirdTongchengParkChannel getThirdTongchengParkChannelByChNo(Long thirdTcParkId, String thirdChannelNo) {
        return getOne(Wrappers.lambdaQuery(ThirdTongchengParkChannel.class)
                .eq(ThirdTongchengParkChannel::getThirdTongchengParkId, thirdTcParkId)
                .eq(ThirdTongchengParkChannel::getThirdChannelCode, thirdChannelNo)
                .last(SqlConstant.LIMIT_ONE));
    }

    @Override
    public ThirdTongchengParkChannel getThirdTongchengParkChannelByChannelCode(Long thirdTcParkId, String channelCode) {
        return getOne(Wrappers.lambdaQuery(ThirdTongchengParkChannel.class)
                .eq(ThirdTongchengParkChannel::getThirdTongchengParkId, thirdTcParkId)
                .eq(ThirdTongchengParkChannel::getChannelCode, channelCode)
                .last(SqlConstant.LIMIT_ONE));
    }

    /**
     * Description: 新增  对象信息 <br>
     * Version1.0 2024-06-20 by wangzhiwei创建
     *
     * @param entity 对象信息
     * @return Boolean 返回新增后主键
     */
    @Override
    public Boolean addThirdTongchengParkChannel (ThirdTongchengParkChannel entity) {
        return save(entity);
    }

    /**
     * Description: 修改 对象信息 <br>
     * Version1.0 2024-06-20 by wangzhiwei创建
     *
     * @param entity 对象信息
     * @return Boolean 返回更新后的结果
     */
    @Override
    public Boolean modifyThirdTongchengParkChannel (ThirdTongchengParkChannel entity) {
        return updateById(entity);
    }

    /**
     * Description: 删除  对象信息 <br>
     * Version1.0 2024-06-20 by wangzhiwei创建
     *
     * @param id 对象id
     * @return Boolean 返回更新后的结果
     */
    @Override
    public Boolean removeThirdTongchengParkChannelById (Long id) {
        return removeById(id);
    }

}
