package com.icetech.third.service.third;

import javax.annotation.Resource;

import com.icetech.cloudcenter.api.third.ThirdTeldRecordService;
import com.icetech.third.dao.third.ThirdTeldRecordDao;
import com.icetech.third.domain.entity.third.ThirdTeldRecord;
import com.icetech.common.domain.response.ObjectResponse;
import org.springframework.stereotype.Service;

@Service
public class ThirdTeldRecordServiceImpl implements ThirdTeldRecordService {
    @Resource
    private ThirdTeldRecordDao thirdTeldRecordDao;

    @Override
    public ObjectResponse<ThirdTeldRecord> getRecordByChargeSeq(String startChargeSeq) {
        ThirdTeldRecord record = thirdTeldRecordDao.getRecordByChargeSeq(startChargeSeq);
        return ObjectResponse.returnNotFoundIfNull(record);
    }

    @Override
    public ObjectResponse<Long> addRecord(ThirdTeldRecord data) {
        int result = thirdTeldRecordDao.insert(data);
        return ObjectResponse.success(data.getId());
    }

    @Override
    public ObjectResponse<Integer> updateRecord(ThirdTeldRecord data) {
        int result = thirdTeldRecordDao.updateById(data);
        return ObjectResponse.success(result);
    }
}
