package com.icetech.third.service.third;

import com.icetech.cloudcenter.api.third.ThirdParkRefService;
import com.icetech.third.dao.third.ThirdParkRefMapper;
import com.icetech.third.domain.entity.third.ThirdParkRef;
import com.icetech.db.mybatis.base.service.impl.BaseServiceImpl;
import org.springframework.stereotype.Service;

/**
 * 三方车场关联信息表 服务实现类
 *
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wangzhiwei
 * @version 1.0 @date 2022-08-16
 */
@Service
public class ThirdParkRefServiceImpl extends BaseServiceImpl<ThirdParkRefMapper, ThirdParkRef> implements ThirdParkRefService {

    /**
     * Description: 根据ID查询 三方车场关联信息表对象信息 <br>
     * Version1.0 2022-08-16 by wangzhiwei创建
     *
     * @param id 对象id
     * @return ThirdParkRef
     */
    @Override
    public ThirdParkRef getThirdParkRefById (Long id) {
        return getById(id);
    }

    /**
     * Description: 新增  三方车场关联信息表对象信息 <br>
     * Version1.0 2022-08-16 by wangzhiwei创建
     *
     * @param entity 对象信息
     * @return Boolean 返回新增后主键
     */
    @Override
    public Boolean addThirdParkRef (ThirdParkRef entity) {
        return save(entity);
    }

    /**
     * Description: 修改 三方车场关联信息表对象信息 <br>
     * Version1.0 2022-08-16 by wangzhiwei创建
     *
     * @param entity 对象信息
     * @return Boolean 返回更新后的结果
     */
    @Override
    public Boolean modifyThirdParkRef (ThirdParkRef entity) {
        return updateById(entity);
    }

    /**
     * Description: 删除  三方车场关联信息表对象信息 <br>
     * Version1.0 2022-08-16 by wangzhiwei创建
     *
     * @param id 对象id
     * @return Boolean 返回更新后的结果
     */
    @Override
    public Boolean removeThirdParkRefById (Long id) {
        return removeById(id);
    }

}
