package com.icetech.third.service.third;

import com.icetech.cloudcenter.api.third.ThirdParamService;
import com.icetech.third.dao.third.ThirdParamMapper;
import com.icetech.third.domain.entity.third.ThirdParam;
import com.icetech.db.mybatis.base.service.impl.BaseServiceImpl;
import org.springframework.stereotype.Service;

/**
 * 三方参数表 服务实现类
 *
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wanggang
 * @version 1.0 @date 2022-09-15
 */
@Service
public class ThirdParamServiceImpl extends BaseServiceImpl<ThirdParamMapper, ThirdParam> implements ThirdParamService {

    /**
     * Description: 根据ID查询 三方参数表对象信息 <br>
     * Version1.0 2022-09-15 by wanggang创建
     *
     * @param id 对象id
     * @return ThirdParam
     */
    @Override
    public ThirdParam getThirdParamById (Long id) {
        return getById(id);
    }

    /**
     * Description: 新增  三方参数表对象信息 <br>
     * Version1.0 2022-09-15 by wanggang创建
     *
     * @param entity 对象信息
     * @return Boolean 返回新增后主键
     */
    @Override
    public Boolean addThirdParam (ThirdParam entity) {
        return save(entity);
    }

    /**
     * Description: 修改 三方参数表对象信息 <br>
     * Version1.0 2022-09-15 by wanggang创建
     *
     * @param entity 对象信息
     * @return Boolean 返回更新后的结果
     */
    @Override
    public Boolean modifyThirdParam (ThirdParam entity) {
        return updateById(entity);
    }

    /**
     * Description: 删除  三方参数表对象信息 <br>
     * Version1.0 2022-09-15 by wanggang创建
     *
     * @param id 对象id
     * @return Boolean 返回更新后的结果
     */
    @Override
    public Boolean removeThirdParamById (Long id) {
        return removeById(id);
    }

}
