package com.icetech.third.service.third;

import com.icetech.third.dao.third.ThirdBstParkMapper;
import com.icetech.third.domain.entity.third.ThirdBstPark;
import com.icetech.db.mybatis.base.service.impl.BaseServiceImpl;
import org.springframework.stereotype.Service;

/**
 * 泊斯特车场 服务实现类
 *
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wgy
 * @version 1.0 @date 2023-06-13
 */
@Service
public class ThirdBstParkServiceImpl extends BaseServiceImpl<ThirdBstParkMapper, ThirdBstPark> implements ThirdBstParkService {

    /**
     * Description: 根据ID查询 泊斯特车场对象信息 <br>
     * Version1.0 2023-06-13 by wgy创建
     *
     * @param id 对象id
     * @return ThirdBstPark
     */
    @Override
    public ThirdBstPark getThirdBstParkById (Long id) {
        return getById(id);
    }

    /**
     * Description: 新增  泊斯特车场对象信息 <br>
     * Version1.0 2023-06-13 by wgy创建
     *
     * @param entity 对象信息
     * @return Boolean 返回新增后主键
     */
    @Override
    public Boolean addThirdBstPark (ThirdBstPark entity) {
        return save(entity);
    }

    /**
     * Description: 修改 泊斯特车场对象信息 <br>
     * Version1.0 2023-06-13 by wgy创建
     *
     * @param entity 对象信息
     * @return Boolean 返回更新后的结果
     */
    @Override
    public Boolean modifyThirdBstPark (ThirdBstPark entity) {
        return updateById(entity);
    }

    /**
     * Description: 删除  泊斯特车场对象信息 <br>
     * Version1.0 2023-06-13 by wgy创建
     *
     * @param id 对象id
     * @return Boolean 返回更新后的结果
     */
    @Override
    public Boolean removeThirdBstParkById (Long id) {
        return removeById(id);
    }

}
