package com.icetech.third.service.third;

import com.alibaba.fastjson.JSON;
import com.aliyun.oss.ServiceException;
import com.icetech.common.constants.CodeConstants;
import com.icetech.sdk.client.OpenClient;
import com.icetech.sdk.request.BaseRequest;
import com.icetech.sdk.request.CommonRequest;
import com.icetech.sdk.response.BaseResponse;
import com.icetech.third.domain.entity.third.ThirdInfo;
import com.icetech.third.service.SendOpenMsgService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

/**
 * Description SendOpenMsgServiceImpl
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wgy
 * @version 1.0 @Date 2023/9/14 11:30
 */
@Slf4j
@Service
public class SendOpenMsgServiceImpl implements SendOpenMsgService {

    @Override
    public <T extends BaseRequest> BaseResponse sendCommonOpenPlatformMsg(ThirdInfo thirdInfo, T obj) {
        try {
            OpenClient client = new OpenClient(thirdInfo.getPushUrl(), thirdInfo.getPid(), thirdInfo.getSecretKey());
            BaseResponse response = client.execute(obj);
            log.info("[第三方信息推送], method[{}] ,返回信息[{}]", obj.getMethod(), JSON.toJSON(response));
            return response;
        } catch (Exception e) {
            throw new ServiceException(CodeConstants.ERROR);
        }
    }
}
