package com.icetech.third.service.extend.impl;

import com.icetech.db.mybatis.base.service.impl.BaseServiceImpl;
import com.icetech.third.dao.send.PushExtendMapper;
import com.icetech.third.domain.entity.third.PushExtend;
import com.icetech.third.service.extend.PushExtendService;
import org.springframework.stereotype.Service;

/**
 * 三方推送扩展信息表 服务实现类
 *
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wanggang
 * @version 1.0 @date 2022-01-11
 */
@Service
public class PushExtendServiceImpl extends BaseServiceImpl<PushExtendMapper, PushExtend> implements PushExtendService {

    /**
     * Description: 根据ID查询 三方推送扩展信息表对象信息 <br>
     * Version1.0 2022-01-11 by wanggang创建
     *
     * @param id 对象id
     * @return PushExtend
     */
    @Override
    public PushExtend getPushExtendById (Long id) {
        return getById(id);
    }

    /**
     * Description: 新增  三方推送扩展信息表对象信息 <br>
     * Version1.0 2022-01-11 by wanggang创建
     *
     * @param entity 对象信息
     * @return Boolean 返回新增后主键
     */
    @Override
    public Boolean addPushExtend (PushExtend entity) {
        return save(entity);
    }

    /**
     * Description: 修改 三方推送扩展信息表对象信息 <br>
     * Version1.0 2022-01-11 by wanggang创建
     *
     * @param entity 对象信息
     * @return Boolean 返回更新后的结果
     */
    @Override
    public Boolean modifyPushExtend (PushExtend entity) {
        return updateById(entity);
    }

    /**
     * Description: 删除  三方推送扩展信息表对象信息 <br>
     * Version1.0 2022-01-11 by wanggang创建
     *
     * @param id 对象id
     * @return Boolean 返回更新后的结果
     */
    @Override
    public Boolean removePushExtendById (Long id) {
        return removeById(id);
    }

}
