package com.icetech.third.service.extend;

import com.icetech.third.domain.entity.third.PushExtend;
import com.icetech.db.mybatis.base.service.IBaseService;

/**
 * 三方推送扩展信息表 服务类
 *
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wanggang
 * @version 1.0 @date 2022-01-11
 */
public interface PushExtendService extends IBaseService<PushExtend> {

    /**
     * Description: 根据ID查询 三方推送扩展信息表对象信息 <br>
     * Version1.0 2022-01-11 by wanggang创建
     *
     * @param id 对象id
     * @return PushExtend
     */
    PushExtend getPushExtendById (Long id);

    /**
     * Description: 新增  三方推送扩展信息表对象信息 <br>
     * Version1.0 2022-01-11 by wanggang创建
     *
     * @param entity 对象信息
     * @return Boolean 返回新增后主键
     */
    Boolean addPushExtend (PushExtend entity);

    /**
     * Description: 修改 三方推送扩展信息表对象信息 <br>
     * Version1.0 2022-01-11 by wanggang创建
     *
     * @param entity 对象信息
     * @return Boolean 返回更新后的结果
     */
    Boolean modifyPushExtend (PushExtend entity);

    /**
     * Description: 删除  三方推送扩展信息表对象信息 <br>
     * Version1.0 2022-01-11 by wanggang创建
     *
     * @param id 对象id
     * @return Boolean 返回更新后的结果
     */
    Boolean removePushExtendById (Long id);
}
