package com.icetech.third.service;

import com.icetech.db.mybatis.base.service.IBaseService;
import com.icetech.third.domain.entity.third.ThirdTongchengPark;

/**
 * 同城支付第三方车场配置 服务类
 *
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wangzhiwei
 * @version 1.0 @date 2024-06-20
 */
public interface ThirdTongchengParkService extends IBaseService<ThirdTongchengPark> {

    /**
     * Description: 根据ID查询 同城支付第三方车场配置对象信息 <br>
     * Version1.0 2024-06-20 by wangzhiwei创建
     *
     * @param id 对象id
     * @return ThirdTongchengPark
     */
    ThirdTongchengPark getThirdTongchengParkById (Long id);

    /**
     * 同程
     * @param thirdParkNo
     * @return
     */
    ThirdTongchengPark getThirdTongchengParkByThirdIdAndParkNo (String thirdParkNo);
    ThirdTongchengPark getThirdTongchengParkByThirdIdAndParkCode (String parkCode);

    /**
     * Description: 新增  同城支付第三方车场配置对象信息 <br>
     * Version1.0 2024-06-20 by wangzhiwei创建
     *
     * @param entity 对象信息
     * @return Boolean 返回新增后主键
     */
    Boolean addThirdTongchengPark (ThirdTongchengPark entity);

    /**
     * Description: 修改 同城支付第三方车场配置对象信息 <br>
     * Version1.0 2024-06-20 by wangzhiwei创建
     *
     * @param entity 对象信息
     * @return Boolean 返回更新后的结果
     */
    Boolean modifyThirdTongchengPark (ThirdTongchengPark entity);

    /**
     * Description: 删除  同城支付第三方车场配置对象信息 <br>
     * Version1.0 2024-06-20 by wangzhiwei创建
     *
     * @param id 对象id
     * @return Boolean 返回更新后的结果
     */
    Boolean removeThirdTongchengParkById (Long id);
}
