package com.icetech.third.service;

import com.icetech.db.mybatis.base.service.IBaseService;
import com.icetech.third.domain.entity.third.ThirdTongchengParkChannel;

/**
 *  服务类
 *
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wangzhiwei
 * @version 1.0 @date 2024-06-20
 */
public interface ThirdTongchengParkChannelService extends IBaseService<ThirdTongchengParkChannel> {

    /**
     * Description: 根据ID查询 对象信息 <br>
     * Version1.0 2024-06-20 by wangzhiwei创建
     *
     * @param id 对象id
     * @return ThirdTongchengParkChannel
     */
    ThirdTongchengParkChannel getThirdTongchengParkChannelById (Long id);

    /**
     *
     * @param thirdTcParkId
     * @param thirdChannelNo
     * @return
     */
    ThirdTongchengParkChannel getThirdTongchengParkChannelByChNo (Long thirdTcParkId,String thirdChannelNo);

    ThirdTongchengParkChannel getThirdTongchengParkChannelByChannelCode (Long thirdTcParkId,String channelNo);

    /**
     * Description: 新增  对象信息 <br>
     * Version1.0 2024-06-20 by wangzhiwei创建
     *
     * @param entity 对象信息
     * @return Boolean 返回新增后主键
     */
    Boolean addThirdTongchengParkChannel (ThirdTongchengParkChannel entity);

    /**
     * Description: 修改 对象信息 <br>
     * Version1.0 2024-06-20 by wangzhiwei创建
     *
     * @param entity 对象信息
     * @return Boolean 返回更新后的结果
     */
    Boolean modifyThirdTongchengParkChannel (ThirdTongchengParkChannel entity);

    /**
     * Description: 删除  对象信息 <br>
     * Version1.0 2024-06-20 by wangzhiwei创建
     *
     * @param id 对象id
     * @return Boolean 返回更新后的结果
     */
    Boolean removeThirdTongchengParkChannelById (Long id);
}
