package com.icetech.third.dao.third;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.icetech.third.domain.entity.third.ThirdTeldPark;
import com.icetech.db.mybatis.base.mapper.SuperMapper;
import org.springframework.stereotype.Repository;

@Repository
public interface ThirdTeldParkDao extends SuperMapper<ThirdTeldPark> {
    default ThirdTeldPark getByParkId(long parkId) {
        return selectLimitOne(Wrappers.lambdaQuery(ThirdTeldPark.class)
                .eq(ThirdTeldPark::getParkId, parkId));
    }

    default ThirdTeldPark getByParkCode(String parkCode) {
        return selectLimitOne(Wrappers.lambdaQuery(ThirdTeldPark.class)
                .eq(ThirdTeldPark::getParkCode, parkCode));
    }
}
