package com.icetech.third.dao.third;


import com.icetech.third.domain.entity.third.ThirdInfo;
import com.icetech.third.domain.entity.third.ThirdPark;
import com.icetech.db.dao.BaseDao;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 第三方与车场关联信息DAO
 * @author fangct
 */
public interface ThirdParkDao extends BaseDao<ThirdPark> {

    ThirdPark selectByParkId(@Param("parkId") Long parkId);

    /**
     * 根据车场ID查询第三方信息
     * @param parkId
     * @return
     */
    List<ThirdInfo> selectThirdByParkId(Long parkId);

    List<ThirdInfo> selectThirdByParkIdAndService(@Param("parkId") Long parkId, @Param("serviceName") String serviceName);

    Integer checkOpenPushAccount(@Param("parkId") Long parkId, @Param("serviceName") String serviceName);

    List<Long> selectParkByPid(String pid);

    ThirdInfo selectThirdByParkIdPID(@Param("parkId") Long parkId, @Param("pid") String pid);

    /**
     * 基于推送地址查询
     * @param parkId
     * @param pushUrl
     * @return
     */
    ThirdInfo selectThirdByParkIdUrl(@Param("parkId") Long parkId, @Param("pushUrl") String pushUrl);

    List<String> selectPermissionServicesByParkId(@Param("parkId") long parkId);
    Integer insertInfoByThird(@Param("thirdPark")ThirdPark thirdPark);

    ThirdInfo selectNoSenConfig(@Param("parkId") Long parkId);

    ThirdInfo selectThirdInfoByParkId(@Param("parkId") Long parkId);

    List<ThirdPark> findAllByParkId(@Param("parkId") Long parkId);

    int deleteByIds(List<Integer> ids);

    List<ThirdInfo> selectNoSenConfigs(@Param("parkId") Long parkId);
}
