package com.icetech.third.dao.third;


import com.icetech.third.domain.entity.third.ThirdInfo;
import com.icetech.cloudcenter.domain.response.ThirdParkInfoResponse;
import com.icetech.db.dao.BaseDao;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 第三方信息DAO
 * @author fangct
 */
public interface ThirdInfoDao extends BaseDao<ThirdInfo> {

    List<ThirdParkInfoResponse> selectByPid(@Param("pid") String pid);

    int  updateParamsById(@Param("params") String params, @Param("id") Integer id);

    ThirdInfo  selectThirdByPid(@Param("pid") String pid);

    /**
     * 获取三方信息通过pid和parkId
     *
     * @param pid
     * @param parkId
     * @return
     */
    ThirdInfo selectThirdInfoBy(@Param("pid") String pid, @Param("parkId") Long parkId);
}
