package com.icetech.third.dao.send;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.icetech.third.domain.entity.third.SendInfo;
import com.icetech.db.mybatis.base.mapper.SuperMapper;
import org.apache.ibatis.annotations.Param;

import java.util.Date;
import java.util.List;

/**
 * 数据下发表
 *
 * @author wangzw
 */
public interface SendinfoDao extends SuperMapper<SendInfo> {
    /**
     * 更新带下发的数据
     *
     * @param iceSendinfo
     * @return
     */
    int updateWaitData(@Param("iceSendinfo") SendInfo iceSendinfo);

    /**
     * 根据类型获取发送信息
     *
     * @param sendType
     * @return
     */
    List<SendInfo> selectBySendTypeAndNum(@Param("sendType") int sendType, @Param("maxNum") int maxNum);

    /**
     * 根据状态获取发送信息
     *
     * @param statusStr
     * @param maxNum
     * @return
     */
    List<SendInfo> selectByStatusAndNum(@Param("statusStr") String statusStr, @Param("maxNum") int maxNum);
    List<SendInfo> selectByStatusAndNum2(@Param("statusStr") String statusStr, @Param("minNum") int minNum, @Param("maxNum") int maxNum);

    List<SendInfo> selectPushList(@Param("statusStr") String statusStr, @Param("maxNum") int maxNum);

    /**
     * 根据业务id 获取下发记录
     *
     * @param serviceType
     * @param serviceId
     * @return
     */
    SendInfo selectByServiceId(@Param("serviceType") Integer serviceType, @Param("serviceId") Integer serviceId, @Param("targetService") Integer targetService);

    /**
     * 查询下发列表
     *
     * @param statusStr
     * @param maxNum
     * @return
     */
    List<SendInfo> selectDownSendList(@Param("statusStr") String statusStr, @Param("maxNum") int maxNum);

    /**
     * 查询已经处理完的历史数据
     *
     * @return
     */
    int deleteSendHistory(@Param("dateTime") Date dateTime);

    /**
     * 删除 iot 发送的历史数据
     *
     * @param dateTime
     * @return
     */
    int deleteIotSendHistory(@Param("dateTime") Date dateTime);

    /**
     * 插入历史表数据
     *
     * @param iceSendinfos
     * @return
     */
    int batchInsertHistory(@Param("list") List<SendInfo> iceSendinfos);

    int insertHistory(SendInfo iceSendinfo);

    int updateSuccessByServiceIds(@Param("ids") List<Long> ids, @Param("serviceType") Integer serviceType, @Param("remark") String remark);

    int finishByServiceIds(@Param("ids") List<Long> ids, @Param("serviceType") Integer serviceType);

    int updateFailByServiceIds(@Param("ids") List<Long> ids, @Param("serviceType") Integer serviceType, @Param("remark") String remark);

    int updateFailByIds(@Param("ids") List<Long> ids, @Param("status") Integer status, @Param("remark") String remark);

    List<Long> selectFailListByIds(@Param("ids") List<Long> ids);

    default SendInfo selectLastSend(long parkId, int serviceType) {
        return selectLimitOne(Wrappers.lambdaQuery(SendInfo.class).eq(SendInfo::getParkId, parkId).eq(SendInfo::getServiceType, serviceType).orderByDesc(SendInfo::getId));
    }
}
