package com.icetech.third.domain.entity.third;

import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

import java.io.Serializable;

/**
 *MQ下发记录表
 * @author fangct
 */
@Setter
@Getter
@ToString
public class SendInfoRecord<T> implements Serializable {
    private Long id;

    private String messageId;

    private Long parkId;

    private String parkCode;

    private Integer serviceType;
    /**
     * 实际下发对应的业务类型
     */
    private Integer reqServiceType;

    private Long serviceId;

    private T params;

    private String response;

    private Integer operType;

    /**
     * 发送目标，端云相机编号
     */
    private String target;
    /**
     * 任务ID
     */
    private Long taskId;
    private Long recordId;

    private String createTime;
    /**
     * 异步回调的topic
     */
    private String topic;
    /**
     * 扩展信息
     */
    private String extraInfo;
    /**
     * 下一个下发的内容
     */
    private T nextPayLoad;
    /**
     * 是否新版本
     */
    private boolean newVersion = true;
    /**
     * 发送消息的环境
     */
    private String env;

}
