package com.icetech.third.domain.entity.third;

import java.io.Serializable;
import java.util.Date;

import com.baomidou.mybatisplus.annotation.FieldStrategy;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

@Getter
@Setter
@ToString
@TableName("`ice_push_record`")
public class PushRecord implements Serializable {
    public static final int PUSH_RESULT_NEW = 0;
    public static final int PUSH_RESULT_FAILED = -1;
    public static final int PUSH_RESULT_SUCCESS = 1;
    
    @TableId("`id`")
    protected Long id;
    @TableField("`msg_id`")
    protected String msgId;
    @TableField("`push_group`")
    protected String pushGroup;
    /**
     * 推送次数
     */
    @TableField("`push_count`")
    protected Integer pushCount;
    /**
     * 推送结果(1成功;-1失败)
     */
    @TableField("`push_result`")
    protected Integer pushResult;
    /**
     * 推送备注
     */
    @TableField("`push_desc`")
    protected String pushDesc;
    /**
     * 备注
     */
    @TableField("`remark`")
    protected String remark;
    @TableField(value = "`create_time`", updateStrategy = FieldStrategy.NEVER)
    protected Date createTime;
    @TableField(value = "`update_time`", updateStrategy = FieldStrategy.NEVER)
    protected Date updateTime;

    public void setRemark(String remark) {
        if (remark != null && remark.length() > 200) {
            remark = remark.substring(0, 200);
        }
        this.remark = remark;
    }
}
