package com.icetech.third.domain.entity.third;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

import java.io.Serializable;
import java.util.Date;

@Getter
@Setter
@ToString
@TableName("`ice_push_message`")
public class PushMessage implements Serializable {
    public static final int MSG_TYPE_ORDER_ENTER = 1;
    public static final int MSG_TYPE_ORDER_EXIT = 2;
    public static final int MSG_TYPE_ORDER_PAY = 3;
    public static final int MSG_TYPE_DEVICE_STATUS_UPDATE = 4;
    public static final int MSG_TYPE_ERROR_OPEN = 5;
    public static final int MSG_TYPE_BATCH_DOWN_SEND = 6;
    public static final int MSG_TYPE_ORDER_SON_ENTER = 7;
    public static final int MSG_TYPE_ORDER_SON_EXIT = 8;
    public static final int MSG_TYPE_FREE_SPACE = 9;
    public static final int MSG_TYPE_REGION_FREE_SPACE = 10;
    public static final int MSG_TYPE_DEVICE_OFFLINE = 11;
    public static final int MSG_TYPE_PNC_CENTER_OFFLINE = 12;
    public static final int MSG_TYPE_PNC_CHARGE_OFFLINE = 13;
    public static final int MSG_TYPE_MONTH_NEAR_EXPIRED = 14;
    public static final int MSG_TYPE_VIP_NEAR_EXPIRED = 15;
    public static final int MSG_TYPE_ZS_BUSY_HINT = 16;

    /**
     * 出场识别
     */
    public static final int MSG_TYPE_EXIT_IDENTIFY = 16;

    @TableId("`id`")
    protected Long id;
    @TableField("`msg_id`")
    protected String msgId;
    @TableField("`park_id`")
    protected Long parkId;
    /**
     * 消息类型(1-入场;2-离场;3-支付;)
     */
    @TableField("`msg_type`")
    protected Integer msgType;
    /**
     * 主数据ID
     */
    @TableField("`data_id`")
    protected String dataId;
    /**
     * 参数
     */
    @TableField("`param`")
    protected String param;
    /**
     * 内容
     */
    @TableField("`content`")
    protected String content;
    /**
     * 发布结果
     */
    @TableField("`publish_result`")
    protected Integer publishResult;
    @TableField("`remark`")
    protected String remark;
    @TableField("`create_time`")
    protected Date createTime;

    public void setContent(String content) {
        if (content != null && content.length() > 1024) {
            content = content.substring(1024);
        }
        this.content = content;
    }
}
