package com.icetech.third.domain.entity.third;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 第三方信息
 * @author
 *  add qrUrl 2021年3月15日
 */
@Data
public class ThirdInfo implements Serializable {
    /**
     * 主键自增长id
     */
    private Integer id;

    /**
     * 第三方接入id
     */
    private String pid;

    /**
     * 第三方名称
     */
    private String name;

    /**
     * 第三方类型 0普通第三方 1.paas第三方
     */
    private Integer thirdType;

    /**
     * 密钥
     */
    private String secretKey;

    public String getPushUrl() {
        return pushUrl != null ? pushUrl.trim() : pushUrl;
    }

    /**
     * 请求地址
     */
    private String pushUrl;

    /**
     * 二维码
     */
    private String qrUrl;
    /**
     * 是否三方收费
     */
    private Integer isThirdPay;
    /**
     * 是否三方计费
     */
    private Integer isThirdFee;
    /**
     * 是否采用第三方广告
     */
    private Integer isThirdAdvice;
    /**
     * 是否支持无感支付(0不支持 1=支持)
     */
    private Integer isNoSenPay;
    /**
     * 优惠券发放张数
     */
    private Integer discountLimit;
    /**
     * 无感支付请求地址
     */
    private String noSenPayUrl;

    /**
     * 备注
     */
    private String remark;
    /**
     * 服务名
     */
    private String serviceName;
    /**
     *
     */
    private String interfacePrefix;

    private Integer authMethod;
    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 更新时间
     */
    private Date updateTime;

    /**
     * 额外字段
     */
    private String params;
    /**
     * 额外字段
     */
    private String status;

    private Integer institutionId;

    /**
     * 用户中心 用户id
     */
    private Integer cUserId;
}
