package com.icetech.third.domain.entity.third;

import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.annotation.IdType;
import java.util.Date;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

/**
 * 三方属性表
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wanggang
 * @version 1.0 @date 2022-09-15
 */
@Data
@EqualsAndHashCode(callSuper = false)
@NoArgsConstructor
@TableName("ice_third_attribute")
@AllArgsConstructor
@Builder
public class ThirdAttribute implements Serializable {

    private static final long serialVersionUID=1L;

    /**
     * id
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /**
     * 三方id
     */
    private Long thirdId;

    /**
     * 字段(英文)
     */
    private String keyName;

    /**
     * 属性名称(中文)
     */
    private String fieldName;

    /**
     * 是否必填:0必填;1非必填
     */
    private Integer required;

    /**
     * 描述 
     */
    private String description;

    /**
     * 排序号
     */
    private Integer sortNum;

    /**
     * 字段类型:1字符串;2数字
     */
    private Integer fieldType;

    /**
     * 模板:对象和数组的模板;用于复杂对接情况下使用
     */
    private String template;

    /**
     * 创建时间
     */
    @TableField(fill = FieldFill.INSERT)
    private Date createTime;

    /**
     * 更新时间
     */
    @TableField(fill = FieldFill.UPDATE)
    private Date updateTime;

    /**
     * 删除标志:0未删除;1已删除
     */
    private Integer deleted;


}
