package com.icetech.third.domain.entity.third;

import java.io.Serializable;
import java.util.Date;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.icetech.common.utils.DateTools;
import lombok.Data;
import lombok.Getter;
import lombok.NoArgsConstructor;

@Data
@NoArgsConstructor
@TableName(value = "`ice_sendinfo`")
public class SendInfo implements Serializable {
    /** 主键自增长id */
    @TableId(value = "`id`")
    protected Long id;
    /**  */
    @TableField(value = "`park_id`")
    protected Long parkId;
    /** 优先级 */
    @TableField(value = "`level`")
    protected Integer level;
    /** 业务类型（1月卡 2云预缴费） */
    @TableField(value = "`service_type`")
    protected Integer serviceType;
    /** 业务id  如业务类型为1此类为月卡操作记录表的ID；  */
    @TableField(value = "`service_id`")
    protected Long serviceId;
    /** 状态(0待下发1成功2暂不下发3延迟下发4失败，默认0 */
    @TableField(value = "`status`")
    protected Integer status;
    /** 是否下发（0未下发，1已下发，2错误，默认0） */
    @TableField(value = "`send_type`")
    protected Integer sendType;
    /** 发送次数 */
    @TableField(value = "`send_num`")
    protected Integer sendNum;
    /** 下次执行时间 */
    @TableField(value = "`next_fire_time`")
    protected Integer nextFireTime;
    /** 人工下发操作人 针对月卡的操作 */
    @TableField(value = "`update_user`")
    protected String updateUser;
    /** 备注 重点记录下发失败的原因 */
    @TableField(value = "`remark`")
    protected String remark;
    /** 目标服务 */
    @TableField(value = "`target_service`")
    protected Integer targetService;
    /** 包含的标识，多个推送对象时需要 */
    @TableField(value = "`include`")
    protected String include;
    /** 车场响应时间 */
    @TableField(value = "`ret_time`")
    protected Date retTime;
    /** 创建时间 */
    @TableField(value = "`create_time`")
    protected Date createTime;
    /** 操作时间 人工下发操作时间 */
    @TableField(value = "`update_time`")
    protected Date updateTime;


    public enum SendTypeEnum{
        ERROR(2),
        YES(1),
        NO(0),
        ;
        private @Getter
        int code;
        SendTypeEnum(int code){
            this.code = code;
        }
    }

    public enum StatusEnum{
        _DEFAULT(0),
        _SUCCESS(1),
        _PASS(2),
        _DELAY(3),
        _FAIL(4),
        ;
        private @Getter int code;
        StatusEnum(int code){
            this.code = code;
        }
    }

    public SendInfo(Long parkId, Long serviceId, Integer serviceType) {
        this.parkId = parkId;
        this.status = SendInfo.StatusEnum._DEFAULT.getCode();
        this.serviceType = serviceType;
        this.serviceId = serviceId;
        this.sendNum = 0;
        this.nextFireTime = (int) DateTools.unixTimestamp();
        this.level = 2;
        this.sendType = 0;
    }

    public static SendInfo buildUnneeded(Long parkId, Long serviceId, Integer serviceType, String reason) {
        SendInfo info = new SendInfo();
        info.setParkId(parkId);
        info.setLevel(9);
        info.setServiceType(serviceType);
        info.setServiceId(serviceId);
        info.setStatus(StatusEnum._PASS.getCode());
        info.setSendType(SendTypeEnum.NO.getCode());
        info.setSendNum(0);
        info.setRemark("{\"type\":\"1\",\"describes\":[{\"failType\":\"10000\",\"fixedDisplay\":\"" + reason + "\"}]}");
        return info;
    }
}
