/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.report.service.impl;

import com.icetech.cloudcenter.api.report.ParkReportStaticsService;
import com.icetech.db.mybatis.base.service.impl.BaseServiceImpl;
import com.icetech.report.dao.ParkReportStaticsMapper;
import com.icetech.report.domain.entity.ParkReportStatics;
import com.icetech.report.domain.vo.ElectronAmountPayNumVo;
import com.icetech.report.domain.vo.ParkChannelReportVo;
import com.icetech.report.domain.vo.ParkChannelStatisticsVo;
import com.icetech.report.domain.vo.ParkPayReportVo;
import com.icetech.third.anno.DS_SLAVE;
import java.math.BigDecimal;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ParkReportStaticsServiceImpl
extends BaseServiceImpl<ParkReportStaticsMapper, ParkReportStatics>
implements ParkReportStaticsService {
    @Autowired
    private ParkReportStaticsMapper parkReportStaticsMapper;

    public ParkReportStatics getParkReportStaticsById(Long id) {
        return (ParkReportStatics)this.getById(id);
    }

    public Boolean addParkReportStatics(ParkReportStatics entity) {
        return this.save(entity);
    }

    public Boolean modifyParkReportStatics(ParkReportStatics entity) {
        return this.updateById(entity);
    }

    public Boolean removeParkReportStaticsById(Long id) {
        return this.removeById(id);
    }

    public ParkChannelStatisticsVo getParkChannelsStatistics(Long reportDate) {
        return this.parkReportStaticsMapper.selectParkChannelsStatistics(reportDate);
    }

    public BigDecimal getTotalPayAmount(Long reportDate) {
        return this.parkReportStaticsMapper.selectTotalPayAmount(reportDate);
    }

    public ElectronAmountPayNumVo getElectronAmountPayNum(Long reportDate) {
        return this.parkReportStaticsMapper.selectElectronAmountPayNum(reportDate);
    }

    public List<ParkPayReportVo> getParkPayMonth(Integer month) {
        return this.parkReportStaticsMapper.selectParkPayMonth(month);
    }

    public List<ParkPayReportVo> getParkPayYear(Integer year) {
        return this.parkReportStaticsMapper.selectParkPayYear(year);
    }

    @DS_SLAVE
    public List<ParkChannelReportVo> getParkNumsYearList(String startTime, String endTime) {
        return this.parkReportStaticsMapper.selectParkNumsYearList(startTime, endTime);
    }

    @DS_SLAVE
    public List<ParkChannelReportVo> getParkNumsMonthList(String startTime, String endTime) {
        return this.parkReportStaticsMapper.selectParkNumsMonthList(startTime, endTime);
    }
}

