/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.report.service.impl;

import com.icetech.cloudcenter.api.report.ParkOtherIncomeService;
import com.icetech.db.mybatis.base.service.impl.BaseServiceImpl;
import com.icetech.report.dao.ParkOtherIncomeMapper;
import com.icetech.report.domain.entity.ParkOtherIncome;
import com.icetech.report.domain.vo.IncomeVo;
import com.icetech.third.anno.DS_SLAVE;
import java.math.BigDecimal;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ParkOtherIncomeServiceImpl
extends BaseServiceImpl<ParkOtherIncomeMapper, ParkOtherIncome>
implements ParkOtherIncomeService {
    @Autowired
    private ParkOtherIncomeMapper parkOtherIncomeMapper;

    public ParkOtherIncome getParkOtherIncomeById(Long id) {
        return (ParkOtherIncome)this.getById(id);
    }

    public Boolean addParkOtherIncome(ParkOtherIncome entity) {
        return this.save(entity);
    }

    public Boolean modifyParkOtherIncome(ParkOtherIncome entity) {
        return this.updateById(entity);
    }

    public Boolean removeParkOtherIncomeById(Long id) {
        return this.removeById(id);
    }

    @DS_SLAVE
    public BigDecimal getYearOtherAmount(Integer year) {
        return this.parkOtherIncomeMapper.selectYearOtherAmount(year);
    }

    @DS_SLAVE
    public List<IncomeVo> getOtherYear(Integer year) {
        return this.parkOtherIncomeMapper.selectOtherYear(year);
    }

    @DS_SLAVE
    public List<IncomeVo> getOtherAmountMonth(Integer month) {
        return this.parkOtherIncomeMapper.selectOtherAmountMonth(month);
    }
}

