package com.icetech.report.domain.vo;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @author wanggang
 * @create 2023-10-16 15:40
 * @desc 新增车场(通道)数统计
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class ParkChannelReportVo implements Serializable {

    /**
     * 车场数
     */
    private Long parkNums;

    /**
     * 车场同比数
     */
    private Long arkIdenticalNums;

    /**
     * 通道数
     */
    private Long channels;

    /**
     * 展示的时间
     */
    private String showTime;

    /**
     * 展示的比例
     */
    private BigDecimal ratio;
}
