package com.icetech.report.domain.entity;

import java.math.BigDecimal;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.annotation.IdType;
import java.util.Date;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;

import lombok.*;

/**
 * 临时车日统计表
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wanggang
 * @version 1.0 @date 2021-10-09
 */
@Data
@Builder
@EqualsAndHashCode(callSuper = false)
@NoArgsConstructor
@AllArgsConstructor
@TableName("ice_temp_car_statistics")
public class TempCarStatistics implements Serializable {

    private static final long serialVersionUID=1L;

    /**
     * id主键
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /**
     * 停车场id
     */
    private Long parkId;

    /**
     * 支付时间，年-月-日
     */
    private String payDate;

    /**
     * 支付宝金额
     */
    private BigDecimal aliAmount;

    /**
     * 微信金额
     */
    private BigDecimal wxAmount;

    /**
     * 现金金额
     */
    private BigDecimal cashAmount;

    /**
     * 银联金额
     */
    private BigDecimal bankAmount;

    /**
     * etc金额
     */

    private BigDecimal etcAmount;

    /**
     * 创建时间
     */
    @TableField(fill = FieldFill.INSERT)
    private Date createTime;

    /**
     * 更新时间
     */
    @TableField(fill = FieldFill.UPDATE)
    private Date updateTime;


}
