package com.icetech.report.domain.entity.screen;

import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.annotation.IdType;

import java.util.Date;

import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;

import java.io.Serializable;

import lombok.*;

/**
 * 屏幕分区车场表
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wanggang
 * @version 1.0 @date 2021-08-06
 */
@Builder
@AllArgsConstructor
@Data
@EqualsAndHashCode(callSuper = false)
@NoArgsConstructor
@TableName("ice_screen_partition_park")
public class ScreenPartitionPark implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * id主键
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    /**
     * 屏幕id
     */
    private Integer screenId;

    /**
     * 屏幕分区id
     */
    private Integer partitionId;

    /**
     * 车场id
     */
    private Integer parkId;

    /**
     * 停车场编码
     */
    private String parkCode;

    /**
     * 显示的静态内容
     */
    private String content;

    /**
     * 创建时间
     */
    @TableField(fill = FieldFill.INSERT)
    private Date createTime;

    /**
     * 更新时间
     */
    @TableField(fill = FieldFill.UPDATE)
    private Date updateTime;

    /**
     * 删除时间
     */
    private Long deleteTime;

    /**
     * 乐观锁
     */
    private Integer version;

    /**
     * 操作人
     */
    private String operator;

    /**
     * 更新人
     */
    private String updateUser;


}
