package com.icetech.report.domain.entity;

import java.math.BigDecimal;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.annotation.IdType;
import java.util.Date;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;

import lombok.*;

/**
 * 
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wanggang
 * @version 1.0 @date 2021-09-08
 */
@Data
@EqualsAndHashCode(callSuper = false)
@AllArgsConstructor
@NoArgsConstructor
@Builder
@TableName("ice_temp_car_report")
public class TempCarReport implements Serializable {

    private static final long serialVersionUID=1L;

    /**
     * id主键
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /**
     * 订单号
     */
    private String orderNum;

    /**
     * 停车场id
     */
    private Integer parkId;

    /**
     * 支付时间，年-月-日 时:分:秒
     */
    private Date payDate;

    /**
     * 实收金额
     */
    private BigDecimal paidPrice;

    /**
     * 优惠金额
     */
    private BigDecimal discountPrice;

    /**
     * 应收金额
     */
    private BigDecimal totalPrice;

    /**
     * 实际收钞
     */
    private BigDecimal actualCash;

    /**
     * 缴费方式1现金，2微信，3支付宝，4银联
     */
    private Integer payWay;

    /**
     * 红包找零
     */
    private BigDecimal redpackRet;

    /**
     * 缴费的通道id
     */
    private String channelId;

    /**
     * 区域id
     */
    private Integer regionId;

    /**
     * 创建时间
     */
    @TableField(fill = FieldFill.INSERT)
    private Date createTime;

    /**
     * 更新时间
     */
    @TableField(fill = FieldFill.UPDATE)
    private Date updateTime;


}
