/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.snowflake;

import java.net.NetworkInterface;
import java.security.SecureRandom;
import java.time.Instant;
import java.util.Enumeration;

public class Snowflake {
    private static final int UNUSED_BITS = 1;
    private static final int EPOCH_BITS = 41;
    private static final int NODE_ID_BITS = 10;
    private static final int SEQUENCE_BITS = 12;
    private static final long maxNodeId = 1023L;
    private static final long maxSequence = 4095L;
    private static final long DEFAULT_CUSTOM_EPOCH = 1583583651535L;
    private final long nodeId;
    private final long customEpoch;
    private volatile long lastTimestamp = -1L;
    private volatile long sequence = 0L;

    public Snowflake(long nodeId, long customEpoch) {
        if (nodeId < 0L || nodeId > 1023L) {
            throw new IllegalArgumentException(String.format("NodeId must be between %d and %d", 0, 1023L));
        }
        this.nodeId = nodeId;
        this.customEpoch = customEpoch;
    }

    public Snowflake(long nodeId) {
        this(nodeId, 1583583651535L);
    }

    public Snowflake() {
        this.nodeId = this.createNodeId();
        this.customEpoch = 1583583651535L;
    }

    public synchronized long nextId() {
        long currentTimestamp = this.timestamp();
        if (currentTimestamp < this.lastTimestamp) {
            throw new IllegalStateException("Invalid System Clock!");
        }
        if (currentTimestamp == this.lastTimestamp) {
            this.sequence = this.sequence + 1L & 0xFFFL;
            if (this.sequence == 0L) {
                currentTimestamp = this.waitNextMillis(currentTimestamp);
            }
        } else {
            this.sequence = 0L;
        }
        this.lastTimestamp = currentTimestamp;
        return currentTimestamp << 22 | this.nodeId << 12 | this.sequence;
    }

    private long timestamp() {
        return Instant.now().toEpochMilli() - this.customEpoch;
    }

    private long waitNextMillis(long currentTimestamp) {
        while (currentTimestamp == this.lastTimestamp) {
            currentTimestamp = this.timestamp();
        }
        return currentTimestamp;
    }

    private long createNodeId() {
        long nodeId;
        try {
            StringBuilder sb = new StringBuilder();
            Enumeration<NetworkInterface> networkInterfaces = NetworkInterface.getNetworkInterfaces();
            while (networkInterfaces.hasMoreElements()) {
                NetworkInterface networkInterface = networkInterfaces.nextElement();
                byte[] mac = networkInterface.getHardwareAddress();
                if (mac == null) continue;
                for (byte macPort : mac) {
                    sb.append(String.format("%02X", macPort));
                }
            }
            nodeId = sb.toString().hashCode();
        }
        catch (Exception ex) {
            nodeId = new SecureRandom().nextInt();
        }
        return nodeId &= 0x3FFL;
    }

    public long[] parse(long id) {
        long maskNodeId = 0x3FF000L;
        long maskSequence = 4095L;
        long timestamp = (id >> 22) + this.customEpoch;
        long nodeId = (id & maskNodeId) >> 12;
        long sequence = id & maskSequence;
        return new long[]{timestamp, nodeId, sequence};
    }

    public String toString() {
        return "Snowflake Settings [EPOCH_BITS=41, NODE_ID_BITS=10, SEQUENCE_BITS=12, CUSTOM_EPOCH=" + this.customEpoch + ", NodeId=" + this.nodeId + "]";
    }
}

