/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.yuneasy.impl;

import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.google.common.collect.Maps;
import com.icetech.cloudcenter.domain.vo.YuneasyCallInfoVo;
import com.icetech.cloudcenter.domain.vo.YuneasyVo;
import com.icetech.common.constants.CodeConstantsEnum;
import com.icetech.common.exception.ResponseBodyException;
import com.icetech.common.utils.JsonUtils;
import com.icetech.park.service.yuneasy.YuneasyService;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class YuneasyServiceImpl
implements YuneasyService {
    private static final Logger log = LoggerFactory.getLogger(YuneasyServiceImpl.class);
    @Value(value="${yuneasy.host.url}")
    private String yuneasyHostUrl;

    @Override
    public YuneasyVo<List<YuneasyCallInfoVo>> getCallInfo(String caller, String callee) {
        YuneasyVo listYuneasyVo = null;
        String result = null;
        try {
            String url = "/ebs/20210805/accounts/calls/getCallInfo.json";
            HashMap param = Maps.newHashMap();
            param.put("caller", caller);
            param.put("callee", callee);
            String request = JSON.toJSONString((Object)param);
            result = HttpUtil.post((String)(this.yuneasyHostUrl + url), (String)request, (int)1000);
            log.info("[\u4e91\u7fcc \u901a\u8bdd\u8bb0\u5f55\u67e5\u8be2],request {} response {}", (Object)request, (Object)result);
            Map stringObjectMap = JsonUtils.parseMap((String)result);
            if ("000000".equals(stringObjectMap.get("statuscode"))) {
                listYuneasyVo = (YuneasyVo)JSON.parseObject((String)result, (TypeReference)new TypeReference<YuneasyVo<List<YuneasyCallInfoVo>>>(){}, (Feature[])new Feature[0]);
            }
        }
        catch (Exception e) {
            log.error("[\u4e91\u7fcc \u901a\u8bdd\u8bb0\u5f55\u67e5\u8be2\u5f02\u5e38],{}", result, (Object)e);
            throw new ResponseBodyException(CodeConstantsEnum.ERROR_510.getCode(), CodeConstantsEnum.ERROR_510.getDesc());
        }
        return listYuneasyVo;
    }
}

