/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.work.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.google.common.collect.Lists;
import com.icetech.cloudcenter.api.park.ParkService;
import com.icetech.common.utils.StringUtils;
import com.icetech.db.mybatis.base.service.impl.BaseServiceImpl;
import com.icetech.park.dao.work.WorkOrderMapper;
import com.icetech.park.domain.dto.QueryWorkOrderDTO;
import com.icetech.park.domain.entity.WorkOrder;
import com.icetech.park.domain.entity.park.Park;
import com.icetech.park.domain.enums.OrderStatus;
import com.icetech.park.domain.vo.WorkOrderCountVo;
import com.icetech.park.domain.vo.WorkOrderPageVo;
import com.icetech.park.service.work.WorkOrderService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class WorkOrderServiceImpl
extends BaseServiceImpl<WorkOrderMapper, WorkOrder>
implements WorkOrderService {
    private final ParkService parkService;

    @Override
    public WorkOrder getWorkOrderById(Long id) {
        return (WorkOrder)this.getById(id);
    }

    @Override
    public Boolean addWorkOrder(WorkOrder entity) {
        return this.save(entity);
    }

    @Override
    public Boolean modifyWorkOrder(WorkOrder entity) {
        return this.updateById(entity);
    }

    @Override
    public Boolean removeWorkOrderById(Long id) {
        return this.removeById(id);
    }

    @Override
    public com.icetech.common.domain.Page<WorkOrderPageVo> page(QueryWorkOrderDTO dto, Long userId, Integer isCs) {
        List parkList = this.parkService.getParkListByUserId(Integer.valueOf(userId.intValue()));
        if (CollectionUtils.isEmpty((Collection)parkList)) {
            return com.icetech.common.domain.Page.instance((int)0, (long)0L, (List)Lists.newArrayList());
        }
        Page page = (Page)this.page((IPage)new Page((long)dto.getPageNo().intValue(), (long)dto.getPageSize().intValue()), (Wrapper)this.getQueryWrapper(dto, userId, isCs, parkList));
        if (Objects.nonNull(page)) {
            List list = page.getRecords().stream().map(t -> {
                WorkOrderPageVo workOrderPageVo = new WorkOrderPageVo();
                BeanUtils.copyProperties((Object)t, (Object)workOrderPageVo);
                if (Objects.nonNull(t.getParkId())) {
                    workOrderPageVo.setParkName(((Park)this.parkService.findByParkId(t.getParkId()).getData()).getParkName());
                }
                return workOrderPageVo;
            }).collect(Collectors.toList());
            return new com.icetech.common.domain.Page(Long.valueOf(page.getTotal()), Integer.valueOf((int)page.getPages()), list);
        }
        return null;
    }

    @Override
    public List<WorkOrderCountVo> orderCount(QueryWorkOrderDTO dto, Long userId, Integer isCs) {
        List parkList = this.parkService.getParkListByUserId(Integer.valueOf(userId.intValue()));
        if (CollectionUtils.isEmpty((Collection)parkList)) {
            return Lists.newArrayList();
        }
        ArrayList list = Lists.newArrayList();
        for (OrderStatus status : OrderStatus.values()) {
            if (status == OrderStatus.RETURNED) continue;
            dto.setStatus(Integer.valueOf(status.getValue()));
            LambdaQueryWrapper<WorkOrder> queryWrapper = this.getQueryWrapper(dto, userId, isCs, this.parkService.getParkListByUserId(Integer.valueOf(userId.intValue())));
            list.add(WorkOrderCountVo.builder().orderStatus(Integer.valueOf(status.getValue())).orderCount(Integer.valueOf(this.count((Wrapper)queryWrapper))).build());
        }
        dto.setStatus(null);
        LambdaQueryWrapper<WorkOrder> queryWrapper = this.getQueryWrapper(dto, userId, isCs, this.parkService.getParkListByUserId(Integer.valueOf(userId.intValue())));
        list.add(WorkOrderCountVo.builder().orderStatus(Integer.valueOf(-1)).orderCount(Integer.valueOf(this.count((Wrapper)queryWrapper))).build());
        return list;
    }

    private LambdaQueryWrapper<WorkOrder> getQueryWrapper(QueryWorkOrderDTO dto, Long userId, Integer isCs, List<Long> parkList) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        if (!parkList.contains(-1L)) {
            queryWrapper.in(WorkOrder::getParkId, parkList);
        }
        if (Objects.nonNull(dto.getStatus()) && dto.getStatus().intValue() == OrderStatus.PENDING.getValue()) {
            if (StringUtils.getInt((Object)isCs) == 0) {
                queryWrapper.in(WorkOrder::getStatus, (Collection)Lists.newArrayList((Object[])new Integer[]{OrderStatus.PENDING.getValue(), OrderStatus.RETURNED.getValue()}));
            } else {
                queryWrapper.eq(Objects.nonNull(dto.getStatus()), WorkOrder::getStatus, (Object)dto.getStatus());
            }
        } else if (Objects.nonNull(dto.getStatus()) && dto.getStatus().intValue() == OrderStatus.COMPLETED.getValue()) {
            if (StringUtils.getInt((Object)isCs) == 1) {
                queryWrapper.in(WorkOrder::getStatus, (Collection)Lists.newArrayList((Object[])new Integer[]{OrderStatus.COMPLETED.getValue(), OrderStatus.RETURNED.getValue()}));
            } else {
                queryWrapper.eq(Objects.nonNull(dto.getStatus()), WorkOrder::getStatus, (Object)dto.getStatus());
            }
        } else {
            queryWrapper.eq(Objects.nonNull(dto.getStatus()), WorkOrder::getStatus, (Object)dto.getStatus());
        }
        queryWrapper.eq(Objects.nonNull(dto.getParkId()), WorkOrder::getParkId, (Object)dto.getParkId());
        queryWrapper.like(StringUtils.isNotEmpty((CharSequence)dto.getCode()), WorkOrder::getCode, (Object)dto.getCode());
        if (Objects.nonNull(dto.getView())) {
            if (dto.getView() == 1) {
                queryWrapper.eq(WorkOrder::getUserId, (Object)userId);
            } else {
                queryWrapper.eq(WorkOrder::getCsUserId, (Object)userId);
            }
        }
        queryWrapper.between(StringUtils.isNotEmpty((CharSequence)dto.getStartTime()) && StringUtils.isNotEmpty((CharSequence)dto.getEndTime()), WorkOrder::getCreateTime, (Object)dto.getStartTime(), (Object)dto.getEndTime());
        if (CollectionUtils.isNotEmpty((Collection)dto.getPriorityTypes())) {
            queryWrapper.in(WorkOrder::getPriority, (Collection)dto.getPriorityTypes().stream().map(QueryWorkOrderDTO.PriorityType::getPriority).collect(Collectors.toList()));
            List allTypes = dto.getPriorityTypes().stream().map(QueryWorkOrderDTO.PriorityType::getTypes).filter(CollectionUtils::isNotEmpty).flatMap(Collection::stream).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(allTypes)) {
                queryWrapper.in(WorkOrder::getType, allTypes);
            }
        }
        queryWrapper.orderByDesc(WorkOrder::getId);
        return queryWrapper;
    }

    public WorkOrderServiceImpl(ParkService parkService) {
        this.parkService = parkService;
    }
}

