/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.video.impl;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import com.icetech.basics.domain.entity.park.ParkInoutdevice;
import com.icetech.cloudcenter.api.ManageService;
import com.icetech.cloudcenter.api.park.ParkDeviceService;
import com.icetech.cloudcenter.api.park.ParkService;
import com.icetech.cloudcenter.domain.vo.ApplyCarVideoVo;
import com.icetech.common.constants.CodeConstantsEnum;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.domain.response.Response;
import com.icetech.order.domain.entity.OrderBack;
import com.icetech.order.domain.entity.OrderNotpay;
import com.icetech.order.service.OrderBackService;
import com.icetech.order.service.OrderNotpayService;
import com.icetech.oss.OssService;
import com.icetech.park.domain.vo.EvidenceVideoVO;
import com.icetech.park.domain.vo.ParkRecoveryVo;
import com.icetech.park.service.park.ParkRecoveryService;
import com.icetech.park.service.video.EvidenceVideoService;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class EvidenceVideoServiceImpl
implements EvidenceVideoService {
    @Autowired
    private OrderNotpayService orderNotpayService;
    @Autowired
    private OrderBackService orderBackService;
    @Autowired
    private ParkRecoveryService parkRecoveryService;
    @Autowired
    private OssService ossService;
    @Autowired
    private ParkDeviceService parkDeviceService;
    @Autowired
    private ManageService manageService;
    @Autowired
    private ParkService parkService;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public ObjectResponse<EvidenceVideoVO> evidenceVideo(Integer type, Long id) {
        ParkRecoveryVo parkRecovery;
        ObjectResponse objectResponse;
        LocalDateTime createTime;
        LocalDate sevenDays = LocalDate.now().minusDays(6L);
        EvidenceVideoVO vo = EvidenceVideoVO.builder().videoUrl("").build();
        Long parkId = null;
        String url = "";
        String videoId = null;
        String plateNum = null;
        Long recTime = null;
        String orderNum = null;
        Long channelId = null;
        LocalDate createDate = null;
        if (type == 1) {
            OrderNotpay notPay = this.orderNotpayService.getOrderNotpayById(id);
            if (notPay == null) {
                return ObjectResponse.failed((CodeConstantsEnum)CodeConstantsEnum.ERROR_402);
            }
            parkId = notPay.getParkId();
            createTime = DateUtil.toLocalDateTime((Date)notPay.getCreateTime());
            createDate = createTime.toLocalDate();
            url = notPay.getEvidenceVideo();
            videoId = notPay.getVideoId();
            plateNum = notPay.getPlateNum();
            recTime = notPay.getExitTime();
            orderNum = notPay.getOrderNum();
            channelId = notPay.getChannelId();
        }
        if (type == 2) {
            OrderBack orderBack = this.orderBackService.getOrderBackById(id);
            if (orderBack == null) {
                return ObjectResponse.failed((CodeConstantsEnum)CodeConstantsEnum.ERROR_402);
            }
            parkId = orderBack.getParkId();
            createTime = DateUtil.toLocalDateTime((Date)orderBack.getCreateTime());
            createDate = createTime.toLocalDate();
            url = orderBack.getEvidenceVideo();
            videoId = orderBack.getVideoId();
            plateNum = orderBack.getPlateNum();
            recTime = orderBack.getExitTime() == null ? orderBack.getBackStartTime() : orderBack.getExitTime();
            orderNum = orderBack.getOrderNum();
            channelId = orderBack.getChannelId();
        }
        vo.setPlateNum(plateNum);
        if (channelId != null && ObjectResponse.isSuccess((Response)(objectResponse = this.parkService.getInoutDeviceById(channelId)))) {
            vo.setChannelName(((ParkInoutdevice)objectResponse.getData()).getInandoutName());
        }
        if ((parkRecovery = this.parkRecoveryService.getParkRecoveryByParkId(parkId)) == null) {
            vo.setIsOpenRecovery(Integer.valueOf(0));
            return ObjectResponse.success((Object)vo);
        }
        Date currentDate = new Date();
        if (DateUtil.compare((Date)currentDate, (Date)DateUtil.parse((CharSequence)parkRecovery.getStartTime())) < 0) {
            vo.setIsOpenRecovery(Integer.valueOf(0));
            return ObjectResponse.success((Object)vo);
        }
        if (DateUtil.compare((Date)currentDate, (Date)DateUtil.parse((CharSequence)parkRecovery.getStartTime())) < 0 || DateUtil.compare((Date)currentDate, (Date)DateUtil.offsetDay((Date)DateUtil.parse((CharSequence)parkRecovery.getEndTime()), (int)1)) >= 0) {
            vo.setIsOpenRecovery(Integer.valueOf(0));
            DateTime endTime = DateUtil.parse((CharSequence)parkRecovery.getEndTime());
            LocalDate endLocalDate = DateUtil.toLocalDateTime((Date)endTime).toLocalDate();
            LocalDate now = LocalDate.now();
            long between = ChronoUnit.DAYS.between(endLocalDate, now);
            vo.setTimeOutDays(Integer.valueOf(Math.toIntExact(between)));
            return ObjectResponse.success((Object)vo);
        }
        vo.setIsOpenRecovery(Integer.valueOf(1));
        ObjectResponse deviceObj = this.parkDeviceService.getDeviceListByChannelId(channelId, Integer.valueOf(9));
        if (!StringUtils.isNotEmpty((CharSequence)url) && !ObjectResponse.isSuccess((Response)deviceObj)) {
            vo.setHasMorCamera(Integer.valueOf(0));
            return ObjectResponse.success((Object)vo);
        }
        vo.setHasMorCamera(Integer.valueOf(1));
        if (createDate != null && (createDate.isAfter(sevenDays) || createDate.isEqual(sevenDays))) {
            vo.setVideoExpire(Integer.valueOf(0));
            if (StringUtils.isNotEmpty((CharSequence)url) && this.ossService.isExistFile(url)) {
                String imageUrl = this.ossService.getImageUrl(url);
                if (!StringUtils.isNotEmpty((CharSequence)imageUrl)) return ObjectResponse.success((Object)vo);
                vo.setVideoUrl(imageUrl);
                return ObjectResponse.success((Object)vo);
            } else {
                ApplyCarVideoVo applyCarVideoVo = new ApplyCarVideoVo();
                applyCarVideoVo.setPlateNum(plateNum);
                applyCarVideoVo.setRecTime(recTime);
                applyCarVideoVo.setVideoType(type);
                applyCarVideoVo.setVideoId(videoId);
                applyCarVideoVo.setParkId(parkId);
                applyCarVideoVo.setOrderNum(orderNum);
                applyCarVideoVo.setChannelId(channelId);
                try {
                    ObjectResponse objectResponse2 = this.manageService.applyCarVideo(applyCarVideoVo);
                    if (!ObjectResponse.isSuccess((Response)objectResponse2)) return ObjectResponse.success((Object)vo);
                    vo.setVideoUrl(this.ossService.getImageUrl((String)objectResponse2.getData()));
                    return ObjectResponse.success((Object)vo);
                }
                catch (Exception e) {
                    return ObjectResponse.success((Object)vo);
                }
            }
        } else {
            vo.setVideoExpire(Integer.valueOf(1));
        }
        return ObjectResponse.success((Object)vo);
    }
}

